<?php

/*
	WPB Filterable Portfolio
	By WPBean
	
*/


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 



/**
 * adding js files
 */

function wpb_fp_adding_scripts() {
	$wpb_fp_show_counting = wpb_fp_get_option( 'wpb_fp_show_counting_', 'wpb_fp_general', 'show' );
	$load_magnific_popup = wpb_fp_get_option( 'wpb_fp_load_magnific_popup', 'wpb_fp_style', 'off' );

	wp_enqueue_script('wpb-fp-mixitup', WPB_FP_URL.'/assets/js/jquery.mixitup.min.js',array('jquery'),'2.1.6', false);

	if( isset($wpb_fp_show_counting) && $wpb_fp_show_counting == 'show' ){
		wp_enqueue_script('wpb-fp-tooltipster', WPB_FP_URL.'/assets/js/jquery.tooltipster.min.js',array('jquery'),'3.3.0', false);
	}

	if( isset($load_magnific_popup) && $load_magnific_popup == 'off' ){
		wp_enqueue_script('wpb-fp-magnific-popup', WPB_FP_URL.'/assets/js/jquery.magnific-popup.min.js',array('jquery'),'1.0', false);
	}	
	wp_enqueue_script('wpb-fp-main-js', WPB_FP_URL.'/assets/js/main.js',array('jquery'),'1.0', false);
}
add_action( 'wp_enqueue_scripts', 'wpb_fp_adding_scripts', 20 ); 




/**
 * adding css files
 */

function wpb_fp_adding_style() {
	if ( !is_admin() ) {
		$wpb_fp_show_counting = wpb_fp_get_option( 'wpb_fp_show_counting_', 'wpb_fp_general', 'show' );
		$load_magnific_popup = wpb_fp_get_option( 'wpb_fp_load_magnific_popup', 'wpb_fp_style', 'off' );
		$load_fa_icon = wpb_fp_get_option( 'wpb_fp_load_fa_icon', 'wpb_fp_style', 'off' );

		wp_enqueue_style('wpb-fp-bootstrap-grid', WPB_FP_URL.'/assets/css/wpb-custom-bootstrap.css','','3.2');
		if( isset($wpb_fp_show_counting) && $wpb_fp_show_counting == 'show' ){
			wp_enqueue_style('wpb-fp-tooltipster', WPB_FP_URL.'/assets/css/tooltipster.css','','3.3.0');
		}
		if( isset($load_fa_icon) && $load_fa_icon == 'off' ){
			wp_enqueue_style('wpb-fp-font-awesome', WPB_FP_URL.'/assets/css/font-awesome.min.css','','4.2.0');
		}	
		if( isset($load_magnific_popup) && $load_magnific_popup == 'off' ){
			wp_enqueue_style('wpb-fp-magnific-popup', WPB_FP_URL.'/assets/css/magnific-popup.css','','1.0');
		}
		wp_enqueue_style('wpb-fp-hover-effects', WPB_FP_URL.'/assets/css/hover-effects.css','','1.0');
		wp_enqueue_style('wpb-fp-font', '//fonts.googleapis.com/css?family=Open+Sans','','1.0');
		wp_enqueue_style('wpb-fp-main', WPB_FP_URL.'/assets/css/main.css','','1.0');
	}

}
add_action( 'wp_enqueue_scripts', 'wpb_fp_adding_style' );




/**
 * Adding Custom styles
 */

add_action( 'wpb_fp_after_portfolio','wpb_fp_custom_style' );
function wpb_fp_custom_style(){
	$wpb_fp_custom_style = wpb_fp_get_option( 'wpb_fp_custom_css_', 'wpb_fp_style', '' );
	if( isset($wpb_fp_custom_style) && !empty($wpb_fp_custom_style) ){
		?>
			<style type="text/css">
			<?php echo $wpb_fp_custom_style;?>
			</style>
		<?php
	}
}



/**
 * Adding Ajax Script
 */


add_action( 'init', 'wpb_fp_ajax_script_enqueuer' );

function wpb_fp_ajax_script_enqueuer() {
   wp_register_script( "wpb_fp_ajax", WPB_FP_URL.'/assets/js/wpb_fp_ajax.js', array('jquery'),'1.0', true );
   wp_localize_script( 'wpb_fp_ajax', 'wpb_fp_ajax_name', array( 'ajax_url' => admin_url( 'admin-ajax.php' )) );        

   wp_enqueue_script( 'jquery' );
   wp_enqueue_script( 'wpb_fp_ajax' );

}
