<?php

/*
	WPB Filterable Portfolio
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 


/* ==========================================================================
   Portfolio Post Category Name in Div class function
   ========================================================================== */

if( !function_exists('wpb_fp_unlink_categories') ):
	function wpb_fp_unlink_categories(){
	    global $post;
	    $category = '';
	    $wpb_fp_taxonomy = wpb_fp_get_option( 'wpb_taxonomy_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio_cat' );
	    $terms = get_the_terms( $post->ID, $wpb_fp_taxonomy );
	                                                   
	    if ( $terms && ! is_wp_error( $terms ) ) :
	     
	            $category_link = array();
	     
	            foreach ( $terms as $term ) {
	                $category_link[] = $term->name;
	            }
	             
	            $category_link = str_replace(' ', '_', $category_link);
	            $category_link = preg_replace('/[^A-Za-z0-9\-]/', '', $category_link); 


	            $category = join( " ", $category_link );
	            $category = strtolower($category);
	           
	    endif;

	    return $category;      
	}
endif;


/* ==========================================================================
   Shortcode For this plugin
   ========================================================================== */


add_shortcode( 'wpb-portfolio','wpb_fp_shortcode_funcation' );	

if( !function_exists( 'wpb_fp_shortcode_funcation' ) ):
	function wpb_fp_shortcode_funcation( $atts ){
		extract(shortcode_atts(array(
			'orderby'				=> 'none', // portfolio orderby
			'order'					=> '', // portfolio order
		), $atts));
	   
		$portfolio_id = rand( 10,1000 );
		$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
		$wpb_fp_pagination = wpb_fp_get_option( 'wpb_fp_pagination', 'wpb_fp_general', 'on' );

		global $post;
		$wpb_fp_number_of_post = wpb_fp_get_option( 'wpb_fp_number_of_post_', 'wpb_fp_general', -1 );
		$wpb_post_type_select = wpb_fp_get_option( 'wpb_post_type_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio' );
		$args 	= array(
			'post_type' 		=> $wpb_post_type_select,
			'posts_per_page'	=> $wpb_fp_number_of_post,
			'meta_query' 		=> array(array('key' => '_thumbnail_id')) 
			
		);

		// Exclude selected categiry form portfolio.
		$wpb_fp_cat_excludes = wpb_fp_get_option( 'wpb_fp_cat_exclude_', 'wpb_fp_advanced' );
		$wpb_fp_taxonomy = wpb_fp_get_option( 'wpb_taxonomy_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio_cat' );
		if( isset($wpb_fp_cat_excludes) && is_array($wpb_fp_cat_excludes) ){
			foreach ($wpb_fp_cat_excludes as $wpb_fp_cat_exclude_key => $wpb_fp_cat_exclude_value) {
				$wpb_fp_cats_ex[] = $wpb_fp_cat_exclude_key;
			}

			$args['tax_query'][] = array(
				'taxonomy' 	=> $wpb_fp_taxonomy,
		        'field'    	=> 'id',
				'terms'    	=> $wpb_fp_cats_ex,
		        'operator' 	=> 'NOT IN' 
			);
		}

		$loop = new WP_Query( $args );
		if ( $loop->have_posts() ) {
			$output = '<div class="wpb_portfolio_area">';
			$terms_args = array();
			if( isset($wpb_fp_cats_ex) && is_array($wpb_fp_cats_ex) ){
				$terms_args = array( 'exclude' => $wpb_fp_cats_ex );
			}

			$terms = get_terms($wpb_fp_taxonomy,$terms_args);
			$count = count($terms);
			if ( $count > 0 ){
				$wpb_fp_filter_position = wpb_fp_get_option( 'wpb_fp_filter_position_', 'wpb_fp_general', 'center' );
				$wpb_fp_filter_style = wpb_fp_get_option( 'wpb_fp_filter_style_', 'wpb_fp_style', 'default' );
				$wpb_fp_show_counting = wpb_fp_get_option( 'wpb_fp_show_counting_', 'wpb_fp_general', 'show' );

				if( isset($wpb_fp_filter_style) && $wpb_fp_filter_style == 'Select' ){
					$output .= '<div id="wpb_fp_filter_select"><a href="#" id="wpb-fp-sort-portfolio"><span>All</span> <i class="fa fa-angle-down"></i></a>';
				}
				
		        $output .= '<ul class="wpb-fp-filter wpb_fp_text-'. $wpb_fp_filter_position .' wpb_fp_filter_'.$wpb_fp_filter_style.'">';
		        $output .= '<li class="filter" data-filter="all">All</li>';
				foreach ( $terms as $term ) {
					$termname = strtolower($term->name);  
					$termname = str_replace(' ', '_', $termname); 
					$termname = preg_replace('/[^A-Za-z0-9\-]/', '', $termname); 
					if( isset($wpb_fp_show_counting) && $wpb_fp_show_counting == 'show' ){   
						$output .= '<li class="filter" data-filter="' . '.' . $termname . '" title="' . $term->count . '">' . $term->name . '</li>';
					}else{
						$output .= '<li class="filter" data-filter="' . '.' . $termname . '">' . $term->name . '</li>';
					}
				}
					$output .= '</ul>';
			
					if( isset($wpb_fp_filter_style) && $wpb_fp_filter_style == 'Select' ){
						$output .= '</div><div class="wpb_fp_clear"></div>';
					}
			}

			$output .= '<div class="wpb_portfolio wpb_fp_row wpb_fp_grid" id="wpb_portfolio_'.$portfolio_id.'">';

			while ( $loop->have_posts() ) : $loop->the_post();
				global $post;
				$thumb = get_post_thumbnail_id();
				$img_url = wp_get_attachment_url( $thumb,'full' );
				$wpb_fp_image_width = wpb_fp_get_option( 'wpb_fp_image_width_', 'wpb_fp_advanced', 275 );
				$wpb_fp_image_height = wpb_fp_get_option( 'wpb_fp_image_height_', 'wpb_fp_advanced', 135 );
				$image_thumb = aq_resize( $img_url, $wpb_fp_image_width, $wpb_fp_image_height, true, true, true ); //resize & crop the image
				$thumbnail_mata = get_post_meta($thumb,'_wp_attachment_image_alt',true);
				$wpb_fp_column = wpb_fp_get_option( 'wpb_fp_column_', 'wpb_fp_general', 4 );
				$wpb_fp_show_overlay = wpb_fp_get_option( 'wpb_fp_show_overlay_', 'wpb_fp_advanced', 'show' );
				$wpb_fp_quickview_icon = wpb_fp_get_option( 'wpb_fp_quickview_icon', 'wpb_fp_advanced', 'show' );
				$wpb_fp_single_portfolio_link = wpb_fp_get_option( 'wpb_fp_single_portfolio_link', 'wpb_fp_advanced', 'show' );
				$wpb_fp_portfolio_ex_link = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				$wpb_fp_popup_effect = wpb_fp_get_option( 'wpb_fp_popup_effect_', 'wpb_fp_style', 'mfp-zoom-in' );
				$wpb_fp_hover_effect = wpb_fp_get_option( 'wpb_fp_hover_effect_', 'wpb_fp_style', 'effect-roxy' );
				$wpb_fp_title_character_limit = wpb_fp_get_option( 'wpb_fp_title_character_limit_', 'wpb_fp_general', 'on' );
				$wpb_fp_number_of_title_character = wpb_fp_get_option( 'wpb_fp_number_of_title_character', 'wpb_fp_general', 16 );
				$wpb_fp_after_title = wpb_fp_get_option( 'wpb_fp_after_title', 'wpb_fp_general', '...' );

				if( $wpb_fp_title_character_limit === 'on' ){
					$portfolio_title = get_the_title();
					$portfolio_title = ( strlen($portfolio_title) > $wpb_fp_number_of_title_character + 2 ) ? substr($portfolio_title,0,$wpb_fp_number_of_title_character ).$wpb_fp_after_title : $portfolio_title;
				}else{
					$portfolio_title = get_the_title();
				}

				$portfolio_permalink = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				if( $portfolio_permalink && $portfolio_permalink != '' ){
					$portfolio_permalink = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				}elseif( isset($wpb_fp_single_portfolio_link) && $wpb_fp_single_portfolio_link == 'show' ){
					$portfolio_permalink = get_permalink();
				}else {
					$portfolio_permalink = '';
				}

				$content_type = get_post_meta( $post->ID, 'wpb_fp_content_type', true );
				$video_iframe = get_post_meta( $post->ID, 'wpb_fp_video_iframe', true );
				$feature_image = '<img src="'.$image_thumb.'" alt="'.$thumbnail_mata.'"/>';

				if( $content_type && $content_type == 'video'){
					$grid_content = $video_iframe;
				}else{
					$grid_content = $feature_image;
				}

				$specific_overlay = get_post_meta( $post->ID, 'wpb_fp_disable_overlay', true );


				$output .= '<div class="wpb_fp_col-md-'.$wpb_fp_column.' wpb_fp_col-sm-6 wpb_fp_col-xs-12 mix '.wpb_fp_unlink_categories().'">';
				$output .= '<figure data-post-id="' . $post->ID . '" class="wpb_fp_preview open-popup-link '. $wpb_fp_hover_effect .'">';
				$output .= $grid_content;
				if( isset($wpb_fp_show_overlay) && $wpb_fp_show_overlay == 'show' && $specific_overlay === '' ):
					$output .= '<figcaption>';
					$output .= '<div>';
					$output .= '<h2>'. $portfolio_title .'</h2>';
					if( isset($portfolio_permalink) || $wpb_fp_quickview_icon == 'show' ):
						$output .= '<p class="wpb_fp_icons">';

						if( isset($wpb_fp_quickview_icon) && $wpb_fp_quickview_icon == 'show' ):
							$output .= '<a data-post-id="' . $post->ID . '" class="wpb_fp_preview open-popup-link" href="#" data-effect="'.$wpb_fp_popup_effect.'"><i class="fa fa-eye"></i></a>';
						endif;
						if( isset($portfolio_permalink) && $portfolio_permalink != '' ):
							$output .= '<a class="wpb_fp_link" href="'.$portfolio_permalink.'"><i class="fa fa-link"></i></a>';
						endif;

						$output .= '</p>';
					endif;
					$output .= '</div>';
					$output .= '</figcaption>';	
				endif;
				$output .= '</figure>';
				$output .= '</div>';
				
			endwhile;

			$output .= '</div><!-- wpb_portfolio -->';
			$output .= '</div><!-- wpb_portfolio_area -->';

			if ( function_exists('wpb_fp_pagination') && $wpb_fp_pagination === 'on' ) {
				$output .=	wpb_fp_pagination( $loop->max_num_pages,"", $paged );
			}

			$output .= do_action('wpb_fp_after_portfolio');
		} else {
			$output = __( 'No portfolio found', WPB_FP_TEXTDOMAIN );
		}
		wp_reset_postdata();
		
		wp_reset_query();
		
		return $output;
	}
endif;



/* ==========================================================================
   Another Portfolio
   Added since V 1.06
   ========================================================================== */

add_shortcode( 'wpb-another-portfolio','wpb_fp_another_portfolio_shortcode_funcation' );

if( !function_exists('wpb_fp_another_portfolio_shortcode_funcation') ):
	function wpb_fp_another_portfolio_shortcode_funcation( $atts ){
		extract(shortcode_atts(array(
			'orderby'				=> 'date', // portfolio orderby
			'order'					=> 'DESC', // portfolio order
			'fp_category'			=> '', // comma separated cat id's
			'exclude_tax'			=> '', // comma separated cat id's
			'posts'					=> -1, // Number of post
			'pagination'			=> '',
		), $atts));
	   
		$portfolio_id = rand( 10,1000 );
		$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

		global $post;
		$wpb_post_type_select = wpb_fp_get_option( 'wpb_post_type_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio' );
		$args 	= array(
			'post_type' 		=> $wpb_post_type_select,
			'posts_per_page'	=> $posts,
			'orderby' 			=> $orderby,
			'order' 			=> $order,
			'meta_query' 		=> array(array('key' => '_thumbnail_id')) 
			
		);

		// Exclude selected categories form portfolio.
		$wpb_fp_taxonomy = wpb_fp_get_option( 'wpb_taxonomy_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio_cat' );
		if( $exclude_tax && $exclude_tax != '' ){
			$exclude_tax = explode(',', $exclude_tax);
			$args['tax_query'][] = array(
				'taxonomy' 	=> $wpb_fp_taxonomy,
		        'field'    	=> 'id',
				'terms'    	=> $exclude_tax,
		        'operator' 	=> 'NOT IN' 
			);
		}

		// only selected categories
		if( $fp_category && $fp_category != '' ){
			$fp_category = explode(',', $fp_category);
			$args['tax_query'][] = array(
				'taxonomy' 	=> $wpb_fp_taxonomy,
		        'field'    	=> 'id',
				'terms'    	=> $fp_category,
		        'operator' 	=> 'IN' 
			);
		}

		$loop = new WP_Query( $args );
		if ( $loop->have_posts() ) {
			$output = '<div class="wpb_portfolio_area wpb_category_portfolio">';
			$terms_args = array();
			if( isset($exclude_tax) && is_array($exclude_tax) ){
				$terms_args = array( 'exclude' => $exclude_tax );
			}
			if( isset($fp_category) && is_array($fp_category) ){
				$terms_args = array( 'include' => $fp_category );
			}

			$terms = get_terms($wpb_fp_taxonomy,$terms_args);
			$count = count($terms);
			if ( $count > 0 ){
				$wpb_fp_filter_position = wpb_fp_get_option( 'wpb_fp_filter_position_', 'wpb_fp_general', 'center' );
				$wpb_fp_filter_style = wpb_fp_get_option( 'wpb_fp_filter_style_', 'wpb_fp_style', 'default' );
				$wpb_fp_show_counting = wpb_fp_get_option( 'wpb_fp_show_counting_', 'wpb_fp_general', 'show' );

				if( isset($wpb_fp_filter_style) && $wpb_fp_filter_style == 'Select' ){
					$output .= '<div id="wpb_fp_filter_select"><a href="#" id="wpb-fp-sort-portfolio"><span>All</span> <i class="fa fa-angle-down"></i></a>';
				}
				
		        $output .= '<ul class="wpb-fp-filter wpb_fp_text-'. $wpb_fp_filter_position .' wpb_fp_filter_'.$wpb_fp_filter_style.'">';
		        $output .= '<li class="filter" data-filter="all">All</li>';
				foreach ( $terms as $term ) {
					$termname = strtolower($term->name);  
					$termname = str_replace(' ', '_', $termname); 
					$termname = preg_replace('/[^A-Za-z0-9\-]/', '', $termname); 
					if( isset($wpb_fp_show_counting) && $wpb_fp_show_counting == 'show' ){   
						$output .= '<li class="filter" data-filter="' . '.' . $termname . '" title="' . $term->count . '">' . $term->name . '</li>';
					}else{
						$output .= '<li class="filter" data-filter="' . '.' . $termname . '">' . $term->name . '</li>';
					}
				}
					$output .= '</ul>';
			
					if( isset($wpb_fp_filter_style) && $wpb_fp_filter_style == 'Select' ){
						$output .= '</div><div class="wpb_fp_clear"></div>';
					}
			}

			$output .= '<div class="wpb_portfolio wpb_fp_row wpb_fp_grid" id="wpb_portfolio_'.$portfolio_id.'">';

			while ( $loop->have_posts() ) : $loop->the_post();
				global $post;
				$thumb = get_post_thumbnail_id();
				$img_url = wp_get_attachment_url( $thumb,'full' );
				$wpb_fp_image_width = wpb_fp_get_option( 'wpb_fp_image_width_', 'wpb_fp_advanced', 275 );
				$wpb_fp_image_height = wpb_fp_get_option( 'wpb_fp_image_height_', 'wpb_fp_advanced', 135 );
				$image_thumb = aq_resize( $img_url, $wpb_fp_image_width, $wpb_fp_image_height, true, true, true ); //resize & crop the image
				$thumbnail_mata = get_post_meta($thumb,'_wp_attachment_image_alt',true);
				$wpb_fp_column = wpb_fp_get_option( 'wpb_fp_column_', 'wpb_fp_general', 4 );
				$wpb_fp_show_overlay = wpb_fp_get_option( 'wpb_fp_show_overlay_', 'wpb_fp_advanced', 'show' );
				$wpb_fp_quickview_icon = wpb_fp_get_option( 'wpb_fp_quickview_icon', 'wpb_fp_advanced', 'show' );
				$wpb_fp_portfolio_ex_link = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				$wpb_fp_popup_effect = wpb_fp_get_option( 'wpb_fp_popup_effect_', 'wpb_fp_style', 'mfp-zoom-in' );
				$wpb_fp_hover_effect = wpb_fp_get_option( 'wpb_fp_hover_effect_', 'wpb_fp_style', 'effect-roxy' );
				$portfolio_title = get_the_title();
				$portfolio_title = (strlen($portfolio_title) > 18) ? substr($portfolio_title,0,16).'...' : $portfolio_title;

				$portfolio_permalink = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				if( $portfolio_permalink && $portfolio_permalink != '' ){
					$portfolio_permalink = get_post_meta( $post->ID, 'wpb_fp_portfolio_ex_link', true );
				}else{
					$portfolio_permalink = get_permalink();
				}


				$output .= '<div class="wpb_fp_col-md-'.$wpb_fp_column.' wpb_fp_col-sm-6 wpb_fp_col-xs-12 mix '.wpb_fp_unlink_categories().'">';
				$output .= '<figure data-post-id="' . $post->ID . '" class="wpb_fp_preview open-popup-link '. $wpb_fp_hover_effect .'">';
				$output .= '<img src="'.$image_thumb.'" alt="img12"/>';
				if( isset($wpb_fp_show_overlay) && $wpb_fp_show_overlay == 'show' ):
					$output .= '<figcaption>';
					$output .= '<div>';
					$output .= '<h2>'. $portfolio_title .'</h2>';
					if( isset($wpb_fp_quickview_icon) && $wpb_fp_quickview_icon == 'show' ):
						$output .= '<p class="wpb_fp_icons">';
						$output .= '<a data-post-id="' . $post->ID . '" class="wpb_fp_preview open-popup-link" href="#" data-effect="'.$wpb_fp_popup_effect.'"><i class="fa fa-eye"></i></a>';
						$output .= '<a class="wpb_fp_link" href="'.$portfolio_permalink.'"><i class="fa fa-link"></i></a>';
						$output .= '</p>';
					endif;
					$output .= '</div>';
					$output .= '</figcaption>';	
				endif;
				$output .= '</figure>';
				$output .= '</div>';
				
			endwhile;

			$output .= '</div><!-- wpb_portfolio -->';
			$output .= '</div><!-- wpb_portfolio_area -->';

			if ( function_exists('wpb_fp_pagination') && $pagination === 'on' ) {
				$output .=	wpb_fp_pagination( $loop->max_num_pages,"", $paged );
			}

			$output .= do_action('wpb_fp_after_portfolio');
		} else {
			$output = __( 'No category portfolio found.', WPB_FP_TEXTDOMAIN );
		}
		
		wp_reset_postdata();
		wp_reset_query();
		
		return $output;
	}
endif;