<?php

/*
    WPB Portfolio PRO
    By WPBean
    
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 



if ( ! function_exists('wpb_fp_post_type_select') ) {

	// Getting all custom post type avaiable for portfolio plugin

	function wpb_fp_post_type_select(){

		$args = array(
		   	'public'   => true,
   			'_builtin' => false
		);

		$rerutn_object = get_post_types( $args );
		$rerutn_object['post'] = 'Post';

		return $rerutn_object;
	}

}

if ( ! function_exists('wpb_fp_taxonomy_select') ) {

	// Getting all custom taxonomy avaiable for portfolio plugin

	function wpb_fp_taxonomy_select(){
		$taxonomy = array();
		$args = array(
			'public' => true,
		);
		$taxonomy_objects = get_taxonomies( $args, 'objects' );
		foreach ($taxonomy_objects as $taxonomy_object) {
			$taxonomy[$taxonomy_object->name] = $taxonomy_object->label;
		}

		return $taxonomy;
	}

}


if ( ! function_exists('wpb_fp_exclude_categories') ) {

	// Exclude selected categiry form portfolio.

	function wpb_fp_exclude_categories(){
		$terms = $category_link = array();
		$wpb_fp_post_type = wpb_fp_get_option( 'wpb_post_type_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio' );
		$taxonomy_objects = get_object_taxonomies( $wpb_fp_post_type, 'objects' );

		if( isset($taxonomy_objects) && !empty($taxonomy_objects) ){
		 	$wpb_fp_taxonomy = wpb_fp_get_option( 'wpb_taxonomy_select_', 'wpb_fp_advanced', 'wpb_fp_portfolio_cat' );
		    $terms = get_terms($wpb_fp_taxonomy);
		    foreach ( $terms as $term ) {
		        $category_link[$term->term_id] = $term->name;
		    }                                         
	      
	    }
	    return $category_link;
	}

}




/**
 * Ajax quick view
 */



add_action('wp_ajax_wpb_fp_quickview', 'wpb_fp_quickview');
add_action('wp_ajax_nopriv_wpb_fp_quickview', 'wpb_fp_quickview');

/** The Quickview Ajax Output **/
if( !function_exists('wpb_fp_quickview') ):
	function wpb_fp_quickview() {
	    global $post;
	    $post_id =  $_POST["portfolio"];
	    $post = get_post($post_id);
	    ob_start();

		require_once WPB_FP_URI. 'inc/content-portfolio-lightbox.php';

	    $output = ob_get_contents();
	    ob_end_clean();
	    echo $output;
	    die();
	}
endif;


/**
 * Gallery Image Size
 */

if( !function_exists('wpb_fp_add_image_sizes') ):
	function wpb_fp_add_image_sizes() {
		$width = wpb_fp_get_option( 'wpb_fp_qv_img_width', 'wpb_fp_gallery', 756 );
		$height = wpb_fp_get_option( 'wpb_fp_qv_img_height', 'wpb_fp_gallery', 423 );
	    add_image_size( 'wpb-fp-full', $width, $height, array( 'center', 'center' ) );
	}
endif;
add_action( 'init', 'wpb_fp_add_image_sizes' );


/**
 * Gallery Setting sections
 */

add_filter( 'wpb_fp_settings_sections', 'wpb_fp_gallery_settings_section', 10 );

if( !function_exists('wpb_fp_gallery_settings_section') ):
	function wpb_fp_gallery_settings_section($sections){
		$wpb_fp_gallery_support = wpb_fp_get_option( 'wpb_fp_gallery_support', 'wpb_fp_general' );

		if( $wpb_fp_gallery_support != 'on' ){
			$sections[] = array(
				'id' 	=> 'wpb_fp_gallery',
	            'title' => __( 'Gallery Settings', WPB_FP_TEXTDOMAIN )
			);
		}

		return $sections;
	}
endif;



/**
 * Gallery Setting fields
 */

add_filter( 'wpb_fp_settings_fields', 'wpb_fp_gallery_settings_fields', 10 );

if( !function_exists('wpb_fp_gallery_settings_fields') ):
	function wpb_fp_gallery_settings_fields($settings_fields){
		$wpb_fp_gallery_support = wpb_fp_get_option( 'wpb_fp_gallery_support', 'wpb_fp_general' );

		if( $wpb_fp_gallery_support != 'on' ){
			$settings_fields['wpb_fp_gallery'] = array(
				array(
                    'name'  => 'wpb_fp_gallery_autoplay',
                    'label' => __( 'Gallery Autoplay ?', WPB_FP_TEXTDOMAIN ),
                    'desc'  => __( 'Yes.', WPB_FP_TEXTDOMAIN ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'      => 'wpb_fp_gallery_speed',
                    'label'     => __( 'Spped', WPB_FP_TEXTDOMAIN ),
                    'desc'      => __( 'Quickview gallery spped. Default: 600', WPB_FP_TEXTDOMAIN ),
                    'type'      => 'number',
                    'default'   => 600
                ),
                array(
                    'name'      => 'wpb_fp_qv_img_width',
                    'label'     => __( 'Image Width', WPB_FP_TEXTDOMAIN ),
                    'desc'      => __( 'Quickview gallery image width. Default 756. Use <a href="https://wordpress.org/plugins/regenerate-thumbnails/" target="_blank">Regenerate Thumbnails</a> plugin & regenerate all thumbnails after changing the size.', WPB_FP_TEXTDOMAIN ),
                    'type'      => 'number',
                    'default'   => 756
                ),
                array(
                    'name'      => 'wpb_fp_qv_img_height',
                    'label'     => __( 'Image height', WPB_FP_TEXTDOMAIN ),
                    'desc'      => __( 'Quickview gallery image height. Default 423', WPB_FP_TEXTDOMAIN ),
                    'type'      => 'number',
                    'default'   => 423
                ),
			);
		}

		return $settings_fields;
	}
endif;



/**
 * Portfolio Pagination 
 */

if( !function_exists('wpb_fp_pagination') ):
	function wpb_fp_pagination($numpages = '', $pagerange = '', $paged='') {

		if (empty($pagerange)) {
			$pagerange = 2;
		}

		/**
		* This first part of our function is a fallback
		* for custom pagination inside a regular loop that
		* uses the global $paged and global $wp_query variables.
		* 
		* It's good because we can now override default pagination
		* in our theme, and use this function in default quries
		* and custom queries.
		*/
		global $paged;
		if (empty($paged)) {
			$paged = 1;
		}
		if ($numpages == '') {
			global $wp_query;
			$numpages = $wp_query->max_num_pages;
			if(!$numpages) {
				$numpages = 1;
			}
		}

		/** 
		* We construct the pagination arguments to enter into our paginate_links
		* function. 
		*/
		$pagination_args = array(
			'base'            => get_pagenum_link(1) . '%_%',
			'format'          => 'page/%#%',
			'total'           => $numpages,
			'current'         => $paged,
			'show_all'        => False,
			'end_size'        => 1,
			'mid_size'        => $pagerange,
			'prev_next'       => True,
			'prev_text'       => __('&laquo;'),
			'next_text'       => __('&raquo;'),
			'type'            => 'plain',
			'add_args'        => false,
			'add_fragment'    => ''
		);

		$paginate_links = paginate_links($pagination_args);

		if ($paginate_links) {
			ob_start();
				echo "<nav class='wpb-fp-pagination'>";
				echo "<span class='page-numbers page-num'>" .__( 'Page ',WPB_FP_TEXTDOMAIN ). $paged . __( ' of ',WPB_FP_TEXTDOMAIN ) . $numpages . "</span> ";
				echo $paginate_links;
				echo "</nav>";
			return ob_get_clean();
		}

	}
endif;