var storelocator = angular.module("storelocator", ['ngResource', 'ngSanitize', 'ngRoute', 'angularFileUpload']);
storelocator.factory('Data', function($http) {

	var resource = {};

	resource.Items = {
		get: function() {
			return $http({method: 'GET', url: DL.ajaxurl, params: {'action': DL.prefix + 'get_items'}});
		},
		add: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'add_item'}, data: data});
		},
		update: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'update_item'}, data: data});
		},
		delete: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'delete_item'}, data: data});
		}
	}

	resource.Sections = {
		get: function() {
			return $http({method: 'GET', url: DL.ajaxurl, params: {'action': DL.prefix + 'get_sections'}});
		},
		add: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'add_section'}, data: data});
		},
		update: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'update_section'}, data: data});
		},
		delete: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'delete_section'}, data: data});
		}
	}

	resource.Icons = {
		get: function() {
			return $http({method: 'GET', url: DL.ajaxurl, params: {'action': DL.prefix + 'get_icons'}});
		},
		add: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'add_icon'}, data: data});
		},
		update: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'update_icon'}, data: data});
		},
		delete: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'delete_icon'}, data: data});
		},
		default: function() {
			return $http({method: 'GET', url: DL.ajaxurl, params: {'action': DL.prefix + 'get_default_icons'}});
		}
	}

	resource.Options = {
		get: function() {
			return $http({method: 'GET', url: DL.ajaxurl, params: {'action': DL.prefix + 'get_options'}});
		},
		update: function(data) {
			return $http({method: 'POST', url: DL.ajaxurl, params: {'action': DL.prefix + 'update_options'}, data: data});
		}
	}

	return resource;
});

storelocator.service('Preloader', function($rootScope){
	var stateObject = {};
	return {
		startLoad: function(key){
			stateObject[key] = 'loading';
			$rootScope.hidePreloader = false;
		},
		endLoad: function(key){
			delete stateObject[key];
			if( Object.keys(stateObject).length == 0 )
			{
				$rootScope.hidePreloader = true;
			}
		}
	};
});

storelocator.filter('page', function() {
	return function(items, curPage, countItems) {
		return (items || []).slice((curPage-1)*countItems, (curPage-1)*countItems + countItems);
	}
});

storelocator.controller('OptionsCtrl', function($scope, $window, Data) {

	$scope.options = {
		color_scheme: {}
	};

	Data.Options.get().success(function(data) {

		$scope.options = data;

		$scope.changeTemplate($scope.options.template);
		$scope.changeAlign($scope.options.infobox_header_align);

	});

	$scope.updateOptions = function() {
		Data.Options.update({fields: $scope.options}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			$window.location.reload();
		});
	}

	$scope.changeScheme = function() {
		angular.forEach($scope.colorSchemes, function(scheme, schemeKey) {
			if (scheme.title == $scope.options.color_scheme.title) {
				// $scope.options.color_scheme = scheme;
				angular.forEach(scheme, function(value, key) {
					if (typeof $scope.options.color_scheme[key] != 'undefined') {
						$scope.options.color_scheme[key] = value;
					}
				});
			}
		});
	}

	$scope.changeTemplate = function(name) {
		angular.forEach($scope.templates, function(template, key) {
			if (key == name) {
				$scope.options.template = key;
				template.active = true;
			} else {
				template.active = false;
			}
		});
	}

	$scope.changeAlign = function(name) {
		angular.forEach($scope.aligns, function(align, key) {
			if (align.name == name) {
				$scope.options.infobox_header_align = align.name;
				align.active = true;
			} else {
				align.active = false;
			}
		});
	}

	$scope.$watchCollection(function() {
    	return $scope.options.color_scheme;
    }, function() {
    	var foundScheme = false;
    	angular.forEach($scope.colorSchemes, function(value, key) {
    		if (angular.equals(value, $scope.options.color_scheme)) {
    			foundScheme = true;
    		}
    	});
    	if (foundScheme == false) {
    		$scope.options.color_scheme.title = 'Custom';
    		angular.forEach($scope.colorSchemes, function(value, key) {
	    		if (value.title == 'Custom') {
	    			value = $scope.options.color_scheme;
	    		}
	    	});
    	}
	});

	$scope.colorSchemes = [
		{
			'title': 'Gray',
			'text_color': '#607d8b',
			'link_color': '#00b0ff',
			'background_color': '#ffffff',
			'header_color': '#455a64',
			'hover_color': '#eceff1',
			'scroll_color': '#cfd8dc',
			'sort': 0
		},
		{
			'title': 'Green',
			'text_color': '#3c8d40',
			'link_color': '#22acc0',
			'background_color': '#ffffff',
			'header_color': '#1e5d23',
			'hover_color': '#e8f5e9',
			'scroll_color': '#c9e6ca',
			'sort': 1
		},
		{
			'title': 'Brown',
			'text_color': '#8c6e64',
			'link_color': '#fb572e',
			'background_color': '#ffffff',
			'header_color': '#5c4038',
			'hover_color': '#efebe9',
			'scroll_color': '#d7ccc8',
			'sort': 2
		},
		{
			'title': 'Purple',
			'text_color': '#5f39af',
			'link_color': '#f10659',
			'background_color': '#ffffff',
			'header_color': '#342090',
			'hover_color': '#ede7f6',
			'scroll_color': '#d1c5e8',
			'sort': 3
		},
		{
			'title': 'Dark',
			'text_color': '#cccccc',
			'link_color': '#ffffff',
			'background_color': '#000000',
			'header_color': '#ffffff',
			'hover_color': '#333333',
			'scroll_color': '#333333',
			'sort': 4
		},
		{
			'title': 'Custom',
			/*'text_color': '#',
			'link_color': '',
			'background_color': '',
			'header_color': '',
			'hover_color': '',
			'scroll_color': '',*/
			'sort': 5
		}
	];

	$scope.templates = {
		'left': {
			'preview': DL.url+'images/preview-left.png',
			'displayName' : DL.l10n.mapleft
		},
		'right': {
			'preview': DL.url+'images/preview-right.png',
			'displayName' : DL.l10n.mapRight
		},
		'top': {
			'preview': DL.url+'images/preview-top.png',
			'displayName' : DL.l10n.mapTop
		}
	};

	$scope.aligns = {
		'left': {
			'name': 'left',
			'icon': DL.url+'images/align-left.png',
			'displayName' : DL.l10n.alignLeft,
			'sort': 0
		},
		'center': {
			'name': 'center',
			'icon': DL.url+'images/align-center.png',
			'displayName' : DL.l10n.alignCenter,
			'sort': 1
		},
		'right': {
			'name': 'right',
			'icon': DL.url+'images/align-right.png',
			'displayName' : DL.l10n.alignRight,
			'sort': 2
		}
	};
});

storelocator.controller('SettingsCtrl', function($scope, $http, $routeParams, Data, FileUploader, Preloader) {

	Preloader.startLoad('Options');
	Data.Options.get().success(function(data) {
		$scope.options = data;

		Preloader.endLoad('Options');
	});

	$scope.togglePanel = function() {
		$scope.options.infobox_hide_itemlist_help = !$scope.options.infobox_hide_itemlist_help;
		Data.Options.update({fields:  {infobox_hide_itemlist_help:$scope.options.infobox_hide_itemlist_help}}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
		});
	}

	$scope.l10n = DL.l10n;
	$scope.worktimeDays = [
		{
			code: '0',
			label:  DL.l10n.Sunday
		},
		{
			code: '1',
			label:  DL.l10n.Monday
		},
		{
			code: '2',
			label:  DL.l10n.Tuesday
		},
		{
			code: '3',
			label:  DL.l10n.Wednesday
		},
		{
			code: '4',
			label:  DL.l10n.Thursday
		},
		{
			code: '5',
			label:  DL.l10n.Friday
		},
		{
			code: '6',
			label:  DL.l10n.Saturday
		}
	];

	$scope.pagination = {
		cur: 1,
		total: 0,
		count: 10
	}

	Preloader.startLoad('Items');
	Data.Items.get().success(function(data) {
		angular.forEach(data, function(value, key) {
			if( value.image != '' )
			{
				value.showImage = DL.upload_dir + value.image;
			}
			else
			{
				value.showImage = '';
			}

		});
		$scope.items = data;
		Preloader.endLoad('Items');
		// $scope.pagination.total = Math.ceil($scope.items.length/$scope.pagination.count);
		// $scope.pagination.total = $scope.pagination.total == 0 ? 1 : $scope.pagination.total;
	});

	Preloader.startLoad('Sections');
	Data.Sections.get().success(function(data) {
		$scope.sections = data;
		Preloader.endLoad('Sections');
	});

	Preloader.startLoad('Icons');
	Data.Icons.get().success(function(data) {
		$scope.icons = data;
		angular.forEach($scope.icons, function(value, key) {
			if( value.isDefault === 0 )
			{
				$scope.icons[key]['showIcon'] = DL.upload_dir + value.src;
			}
			else if( value.isDefault === 1 )
			{
				$scope.icons[key]['showIcon'] = DL.url + value.src;
			}
		});
		Preloader.endLoad('Icons');
	});

	$scope.deleteItem = function(id) {

		if (confirm(DL.l10n.AreYouSure)) {
			Data.Items.delete({fields: {id: id}}).success(function(request) {
				if (request == 0) {
					alert('Error!');
				}
				if (request != false) {
					angular.forEach($scope.items, function(value, key) {
						if (value.id == id) {
							$scope.items.splice(key, 1);
						}
					});
				} else {
					alert('Error');
				}
			});
		}
	}

	var addIcon = function(icon) {
		Data.Icons.add({fields: icon}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			icon.id = request;
			$scope.icons[icon.id] = icon;
		});
	}

	/*$scope.uploader = new FileUploader({
		url: '/?dl_store_locator=true&dl_action=upload_icon',
		autoUpload: true,
		onSuccessItem: function(item, response) {
			addIcon({src:response.src});
		}
	});*/

	$scope.checked = false;

	$scope.checkAllItems = function() {
		if ($scope.checked == true) {
			$scope.checked = false;
			angular.forEach($scope.items, function(value, key) {
				value.checked = false;
			});
		} else {
			$scope.checked = true;
			angular.forEach($scope.items, function(value, key) {
				value.checked = true;
			});
		}
	}

	return Data;
});

storelocator.controller('ItemAddCtrl', function($scope, $location, Data, FileUploader) {

	$scope.item = {
		coordinates: ''
	};

	$scope.item.active = '1';
	$scope.item.sort = '500';

	for (var i in $scope.icons) {
        $scope.item.icon = $scope.icons[i].id;
        break;
    }

    for (var i in $scope.sections) {
        $scope.item.section_id = $scope.sections[i].id;
        break;
    }

	$scope.addItem = function() {
		Data.Items.add({fields: $scope.item}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			$scope.item.id = request;
			$scope.items.push($scope.item);
			$location.path('/item/list');
		});
	}

	$scope.deleteImage = function() {
		$scope.item.image = '';
		$scope.item.showImage = '';
	}

	$scope.addNewSection = function() {
		var section = {name: $scope.newSection};
		Data.Sections.add({fields: section}).success(function(id) {
			section.id = id;
			$scope.sections[id] = section;
			$scope.item.section_id = id;
			$scope.showAddNewSection = false;
			$scope.newSection = "";
		});
	}

	$scope.showImagePreloader = false;

	$scope.uploaderItemImage = new FileUploader({
		url: DL.ajaxurl + '&action=dl_upload_image',
		autoUpload: true,
		onSuccessItem: function(item, response) {
			$scope.item.image = response.relativePath;
			$scope.item.showImage = DL.upload_dir + $scope.item.image;
		},
		onBeforeUploadItem: function(item) {
			$scope.showImagePreloader = true;
		},
		onCompleteAll: function(item) {
			$scope.showImagePreloader = false;
			
		}
	});
});

storelocator.controller('ItemEditCtrl', function($scope, $location, $routeParams, Data, FileUploader, Preloader) {

	angular.forEach($scope.items, function(value, key) {
		if (value.id == $routeParams.id) {
			if (typeof $scope.icons[value.icon] == 'undefined') {
				for (var i in $scope.icons) {
			        value.icon = $scope.icons[i].id;
			        break;
			    }
			}
			$scope.item = angular.copy(value);
			if( $scope.item.image != '')
			{
				$scope.item.showImage = DL.upload_dir + $scope.item.image;
			}
		}
	});

	$scope.cancel = function() {
		$location.path('/item/list');
	}

	$scope.updateItem = function() {
		Data.Items.update({fields: $scope.item}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			angular.forEach($scope.items, function(value, key) {
				if (value.id == $scope.item.id) {
					$scope.items[key] = $scope.item;
				}
			});
			$location.path('/item/list');
		});
	}

	$scope.deleteImage = function() {
		$scope.item.image = '';
		$scope.item.showImage = '';
	}

	$scope.addNewSection = function() {
		var section = {name: $scope.newSection};
		Data.Sections.add({fields: section}).success(function(id) {
			section.id = id;
			$scope.sections[id] = section;
			$scope.item.section_id = id;
			$scope.showAddNewSection = false;
			$scope.newSection = "";
		});
	}

	$scope.showImagePreloader = false;

	$scope.uploaderItemImage = new FileUploader({
		url: DL.ajaxurl + '&action=dl_upload_image',
		autoUpload: true,
		onSuccessItem: function(item, response) {
			$scope.item.image = response.relativePath;
			$scope.item.showImage = DL.upload_dir + $scope.item.image;
		},
		onBeforeUploadItem: function(item) {
			$scope.showImagePreloader = true;
		},
		onCompleteAll: function(item) {
			$scope.showImagePreloader = false;
			
		}
	});

});

storelocator.controller('SectionsCtrl', function($scope, $routeParams, $location, Data, Preloader) {


	$scope.l10n = DL.l10n;

	Preloader.startLoad('Options');
	Data.Options.get().success(function(data) {
		$scope.options = data;

		Preloader.endLoad('Options');
	});

	$scope.togglePanel = function() {
		$scope.options.infobox_hide_sectionlist_help = !$scope.options.infobox_hide_sectionlist_help;
		Data.Options.update({fields:  {infobox_hide_sectionlist_help:$scope.options.infobox_hide_sectionlist_help}}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
		});
	}

	$scope.pagination = {
		cur: 1,
		total: 0,
		count: 10
	}

	$scope.sections = {};

	Preloader.startLoad('Sections');
	Data.Sections.get().success(function(data) {
		$scope.sections = data;
		// $scope.pagination.total = Math.ceil(Object.keys($scope.sections).length/$scope.pagination.count);
		// $scope.sections_delete = Object.keys($scope.sections).length > 1 ? 1 : 0;
		Preloader.endLoad('Sections');
	});

	$scope.deleteSection = function(id) {

		if (confirm(DL.l10n.AreYouSureSection)) {
			Data.Sections.delete({fields: {id: id}}).success(function(request) {
				if (request == 0) {
					alert('Error!');
				}
				if (request != false) {
					delete($scope.sections[id]);
					Data.Items.delete({fields: {section_id: id}});
				} else {
					alert('Error');
				}
			});
		}
	}

	$scope.$watchCollection(function() {
		return $scope.sections;
	}, function() {
		$scope.sections_delete = Object.keys($scope.sections).length > 1 ? 1 : 0;
	});

});

storelocator.controller('SectionAddCtrl', function($scope, $location, Data) {

	$scope.section = {};
	$scope.section.active = '1';
	// $scope.section.active = true;

	$scope.addSection = function() {
		Data.Sections.add({fields: $scope.section}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			$scope.section.id = request;
			$scope.sections[$scope.section.id] = $scope.section;
			$location.path('/section/list');
		});
	}
});

storelocator.controller('SectionEditCtrl', function($scope, $location, $routeParams, Data) {

	$scope.section = $scope.sections[$routeParams.id];

	var clone = angular.copy($scope.section);

	$scope.cancel = function() {
		$scope.sections[$routeParams.id] = angular.copy(clone);
		$location.path('/section/list');
	}

	$scope.updateSection = function() {
		Data.Sections.update({fields: $scope.section}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			$scope.sections[$routeParams.id] = $scope.section;
			$location.path('/section/list');
		});
	}
});

storelocator.controller('IconsCtrl', function($scope, $routeParams, $location, Data, FileUploader, Preloader) {

	$scope.l10n = DL.l10n;
	$scope.DL = DL;
	
	Preloader.startLoad('Options');
	Data.Options.get().success(function(data) {
		$scope.options = data;

		Preloader.endLoad('Options');
	});

	$scope.togglePanel = function() {
		$scope.options.infobox_hide_typeslist_help = !$scope.options.infobox_hide_typeslist_help;
		Data.Options.update({fields:  {infobox_hide_typeslist_help:$scope.options.infobox_hide_typeslist_help}}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
		});
	}

	$scope.pagination = {
		cur: 1,
		total: 0,
		count: 10
	}

	$scope.icons = {};

	Preloader.startLoad('Icons');
	Data.Icons.get().success(function(data) {
		$scope.icons = data;
		// $scope.pagination.total = Math.ceil(Object.keys($scope.icons).length/$scope.pagination.count);
		// $scope.icons.length = Object.keys($scope.icons).length;

		angular.forEach($scope.icons, function(value, key) {
			if( value.isDefault === 0 )
			{
				$scope.icons[key]['showIcon'] = DL.upload_dir + value.src;
			}
			else if( value.isDefault === 1 )
			{
				$scope.icons[key]['showIcon'] = DL.url + value.src;
			}
		});
		Preloader.endLoad('Icons');
	});

	Preloader.startLoad('DefaultIcons');
	Data.Icons.default().success(function(data) {
		$scope.defaultIcons = data;
		Preloader.endLoad('DefaultIcons');
	});



	$scope.deleteIcon = function(id) {

		if (confirm(DL.l10n.AreYouSureType)) {
			Data.Icons.delete({fields: {id: id}}).success(function(request) {
				if (request == 0) {
					alert('Error!');
				}
				if (request != false) {
					delete($scope.icons[id]);
					Data.Items.delete({fields: {icon: id}});
				} else {
					alert('Error');
				}
			});
		}
	}

	$scope.$watchCollection(function() {
		return $scope.icons;
	}, function() {
		$scope.icons_delete = Object.keys($scope.icons).length > 1 ? 1 : 0;
	});

});

storelocator.controller('IconAddCtrl', function($scope, $location, Data, FileUploader) {

	

	$scope.icon = {};
	$scope.icon.active = '1';
	$scope.icon.src = $scope.defaultIcons[0];
	$scope.icon.isDefault = 1;

	$scope.changeIcon = function(icon) {
		$scope.icon.src = icon;
		if( $scope.defaultIcons.indexOf( $scope.icon.src ) !== -1 )
		{
			$scope.icon.isDefault = 1;
		}
		else
		{
			$scope.icon.isDefault = 0;
		}
	}

	$scope.addIcon = function() {
		Data.Icons.add({fields: $scope.icon}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}
			$scope.icon.id = request;
			if( $scope.icon.isDefault == 0 )
			{
				$scope.icon.showIcon = DL.upload_dir + $scope.icon.src;
			}
			else if( $scope.icon.isDefault == 1 )
			{
				$scope.icon.showIcon = DL.url + $scope.icon.src;
			}
			$scope.icons[$scope.icon.id] = $scope.icon;
			$location.path('/icon/list');
		});
	}

	$scope.uploaderIcon = new FileUploader({
		url: DL.ajaxurl + '&action=dl_upload_icon',
		autoUpload: true,
		onSuccessItem: function(item, response) {
			$scope.icon.src = response.relativePath;
			$scope.customIcon = response.relativePath;

			$scope.icon.isDefault = 0;

			$scope.icon.showIcon = DL.upload_dir + $scope.icon.src;
		}
	});

});

storelocator.controller('IconEditCtrl', function($scope, $location, $routeParams, Data, FileUploader) {


	$scope.icon = $scope.icons[$routeParams.id];
	
	if( $scope.icon.isDefault == 0)
	{
		$scope.icon.showIcon = DL.upload_dir + $scope.icon.src;
	}
	else if( $scope.icon.isDefault == 1 )
	{
		$scope.icon.showIcon = DL.url + $scope.icon.src;
	}
	var clone = angular.copy($scope.icon);

	angular.forEach($scope.defaultIcons, function(value, key) {
		if ($scope.icon.src == value) {
			$scope.customIcon = false;
		}
	});

	if ($scope.customIcon != false) {
		$scope.customIcon = $scope.icon.src;
	}

	$scope.cancel = function() {
		$scope.icons[$routeParams.id] = angular.copy(clone);
		$location.path('/icon/list');
	}

	$scope.changeIcon = function(icon) {
		$scope.icon.src = icon;
		if( $scope.defaultIcons.indexOf( $scope.icon.src ) !== -1 )
		{
			$scope.icon.isDefault = 1;
		}
		else
		{
			$scope.icon.isDefault = 0;
		}
	}

	$scope.updateIcon = function() {
		Data.Icons.update({fields: $scope.icon}).success(function(request) {
			if (request == 0) {
				alert('Error!');
			}

			if( $scope.icon.isDefault == 0 )
			{
				$scope.icon.showIcon = DL.upload_dir + $scope.icon.src;
			}
			else if( $scope.icon.isDefault == 1 )
			{
				$scope.icon.showIcon = DL.url + $scope.icon.src;
			}

			$scope.icons[$routeParams.id] = $scope.icon;
			$location.path('/icon/list');
		});
	}

	$scope.uploaderIcon = new FileUploader({
		url: DL.ajaxurl + '&action=dl_upload_icon',
		autoUpload: true,
		onSuccessItem: function(item, response) {
			$scope.icon.src = response.relativePath;
			$scope.customIcon = response.relativePath;

			$scope.icon.isDefault = 0;

			$scope.icon.showIcon = DL.upload_dir + $scope.icon.src;

		}
	});
});

storelocator.config(function($routeProvider) {
	$routeProvider
		.when('/item/add', {
			templateUrl: DL.url + 'views/item_add.php',
			controller: 'ItemAddCtrl',
			resolve: {
				get: function(Data) {
					return Data.Items.get();
				}
			}
		})
		.when('/item/edit/:id', {
			templateUrl: DL.url + 'views/item_edit.php',
			controller: 'ItemEditCtrl',
			resolve: {
				get: function(Data) {
					return Data.Items.get();
				}
			}
		})
		.when('/section/list', {
			templateUrl: DL.url + 'views/section_list.php'
		})
		.when('/section/add', {
			templateUrl: DL.url + 'views/section_add.php',
			controller: 'SectionAddCtrl'
		})
		.when('/section/edit/:id', {
			templateUrl: DL.url + 'views/section_edit.php',
			controller: 'SectionEditCtrl',
			resolve: {
				get: function(Data) {
					return Data.Sections.get();
				}
			}
		})
		.when('/icon/add', {
			templateUrl: DL.url + 'views/icon_add.php',
			controller: 'IconAddCtrl'
		})
		.when('/icon/edit/:id', {
			templateUrl: DL.url + 'views/icon_edit.php',
			controller: 'IconEditCtrl',
			resolve: {
				get: function(Data) {
					return Data.Icons.get();
				}
			}
		}).
		when('/icon/list', {
			templateUrl: DL.url + 'views/icon_list.php'
		}).
		when('/item/list', {
			templateUrl: DL.url + 'views/item_list.php'
		})
		.otherwise({
			// redirectTo: '/item/list'
			templateUrl: DL.url + '/views/item_list.php'
		});
});

storelocator.directive('ngEnter', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keypress", function (event) {
            if(event.which === 13) {
                scope.$apply(function (){
                    scope.$eval(attrs.ngEnter);
                });

                event.preventDefault();
            }
        });
    };
});

storelocator.directive('multipleSelect', function($timeout, $parse) {
	return {
		require: '?ngModel',
		restrict: 'EA',
		scope: {
			selectOptions: '='
		},
		link: function(scope, element, attrs, ngModelCtrl) {
			$timeout(function() {
				if (typeof scope.selectOptions != 'object') {
					scope.selectOptions = {};
				}
				var setView = function() {
					return function() {
						var select = jQuery(element).multipleSelect('getSelects');
						ngModelCtrl.$setViewValue(select);
					}
				}
				scope.selectOptions.onClick = setView();
				scope.selectOptions.onCheckAll = setView();
				scope.selectOptions.onUncheckAll = setView();
				scope.selectOptions.placeholder = DL.l10n.selectDays;
				jQuery(element).multipleSelect(scope.selectOptions);
				var li = jQuery(element).closest('li');
				jQuery(document).click(function(e) {
					if (jQuery(e.target).closest(li).length) {
						return;
					}
					jQuery(element).multipleSelect('close');
				});
			}, 0);
			
			var initNgModel = false;

			scope.$watch(function() {
				return ngModelCtrl.$viewValue;
			}, function(newVal, oldVal) {
				if ((angular.equals(newVal, oldVal) == false || initNgModel == false) && typeof newVal != 'undefined') {
					initNgModel = true;
					$timeout(function() {
						jQuery(element).multipleSelect('setSelects', newVal);
					}, 0);
				}
			});
		}
	}
});

storelocator.directive('worktime', function($timeout) {
	return {
		restrict: 'EA',
		replace: true,
		templateUrl: DL.url + 'views/worktime.php',
		scope: {
			worktimes: '=',
			days: '=',
			l10n: '='
		},
		link: function (scope, element, attrs) {
			scope.selectOptions = {
				keepOpen: false
			};
			scope.addWorktime = function() {
				scope.worktimes.push({});
			}
			scope.deleteWorktime = function(key) {
				if (scope.showDelete == true) {
					scope.worktimes.splice(key, 1);
				} else {
					scope.worktimes = [[]];
				}
			}
			scope.showAdd = function(key) {
				var lastKey = scope.worktimes.length - 1;
				if (lastKey == key) {
					var end = scope.worktimes[scope.worktimes.length-1];
					if (angular.equals(end, {})) {
						return false;
					} else {
						return true;
					}
				}
			}

			scope.$watch(function() {
				return angular.toJson(scope.worktimes);
			}, function() {
				if (typeof scope.worktimes != 'object') {
					scope.worktimes = [];
					scope.worktimes.push({});
				}
				if (scope.worktimes.length > 1) {
					scope.showDelete = true;
				} else {
					scope.showDelete = false;
				}
			});
		}
	}
});

storelocator.directive('pagination', function() {
	return {
        restrict: 'EA',
        replace: true,
        templateUrl: DL.url + 'views/pagination.php',
        scope: {
            cur: '=',
            total: '=',
            display: '@',
            count: '=',
            l10n: '='
        },
        link: function (scope, element, attrs) {
            var calcPages = function () {
                var display = +scope.display;
                var delta = Math.floor(display / 2);
                scope.start = scope.cur - delta;
                if (scope.start < 1) {
                    scope.start = 1;
                }
                scope.end = scope.start + display - 1;
                if (scope.end > scope.total) {
                    scope.end = scope.total;
                    scope.start = scope.end - (display - 1);
                    if (scope.start < 1) {
                        scope.start = 1;
                    }
                }

                scope.pages = [];
                for (var i = scope.start; i <= scope.end; ++i) {
                    scope.pages.push(i);
                }
            };
            scope.$watch('cur', calcPages);
            scope.$watch('total', calcPages);
            scope.$watch('display', calcPages);

            scope.$watch(function() {
            	return scope.count;
            }, function(newVal, oldVal) {
            	if (typeof newVal == 'object') {
            		newVal = Object.keys(newVal).length;
            	}
            	scope.items = newVal;
            	// newVal = typeof newVal == 'object' ? Object.keys(newVal).length : newVal.length;
            	// oldVal = typeof oldVal == 'object' ? Object.keys(oldVal).length : oldVal.length;
            	// if (newVal != oldVal) {
	            	scope.total = Math.ceil(newVal/scope.display);
	            	scope.total = scope.total == 0 ? 1 : scope.total;
	            	if (scope.cur > scope.total) {
	            		scope.cur = scope.total;
	            	}
	            // }
            });

            scope.isCurrent = function (index) {
                return scope.cur == index;
            };

            scope.setCurrent = function (index) {
                scope.cur = index;
            };

            scope.hasPrev = function () {
                return scope.cur > 1;
            };
            scope.prev = function () {
                if (scope.hasPrev()) scope.cur--;
            };

            scope.hasNext = function () {
                return scope.cur < scope.total;
            };
            scope.next = function () {
                if (scope.hasNext()) scope.cur++;
            };

            scope.firstPage = function () {
                // return scope.start == 1;
                return scope.cur == 1;
            };
            scope.goToFirstPage = function () {
                if (!scope.firstPage()) scope.cur = 1;
            };
            scope.lastPage = function () {
                // return scope.end == scope.total;
                return scope.cur == scope.total;
            };
            scope.goToLastPage = function () {
                if (!scope.lastPage()) scope.cur = scope.total;
            };
        }
    };
});

storelocator.directive('wpColorPicker', function($parse) {
	return {
		require: '?ngModel',
        restrict: 'A',
        replace: true,
        // scope: {},
		link: function(scope, element, attrs, ngModelCtrl) {
			// var modelAccessor = $parse(attrs.ngModel);
			jQuery(element).wpColorPicker({
				change: function(event, ui) {
					jQuery(this).val(ui.color.toString());
					jQuery(element).change();
				}
			});
			jQuery(element).on('change', function() {
	    		ngModelCtrl.$setViewValue(jQuery(this).val());
	    	});
			scope.$watch(function() {
	        	return ngModelCtrl.$viewValue;
	        }, function(newVal, oldVal) {
				if (typeof newVal != 'undefined') {
					jQuery(element).change();
				}
			});
		}
	}
});

storelocator.directive('select2', function($timeout) {
    return {
    	require: '?ngModel',
        restrict: 'A',
        scope: {
        	selectItems: '='
        },
        link: function(scope, element, attr, ngModelCtrl) {

	        var formatState = function(state) {
	    		if (!state.id || state.id == '?') {
	    			return state.text;
	    		}
	    		// if (typeof scope.selectItems[state.id].src != 'undefined') {
	    		if ('src' in scope.selectItems[state.id]) {
	    			var html = '' +
	    				'<span class="dl-select-icon clearfix">' +
	    					'<span class="dl-select-img">' +
	    						'<img class="dl-select-img-img" src="' + scope.selectItems[state.id].showIcon + '">' +
	    					'</span>' +
	    					'<span>' + state.text + '</span>' + 
	    				'</span>';
	        		var $state = jQuery(html);
	        		return $state;
	    		}
	    	}

	    	jQuery(element).on('change', function() {
	    		ngModelCtrl.$setViewValue(jQuery(this).val());
	    	});

	        element.select2({
	        	minimumResultsForSearch: Infinity,
	        	templateResult: formatState,
	        	templateSelection: formatState
	        });

	        var init = false;

	        // update the select when the model changes
	        scope.$watch(function() {
	        	return ngModelCtrl.$viewValue;
	        }, function(newVal, oldVal) {
	        	if ((newVal != oldVal && newVal != '?' && typeof newVal != 'undefined') || init == false) {
	        		init = true;
	        		$timeout(function() {
	        			element.val(newVal).trigger('change');
	        		}, 0);
	        	}
	        });
	    }
    };
});

storelocator.directive('googleMap', function($timeout) {
	return {
		require: '?ngModel',
		scope: {
			address: '='
		},
		link: function(scope, element, attr, ngModelCtrl) {

			var marker, map, geocoder;

			var initialize = function()
			{
				var lat = 48.632909;
				var lng = 12.216797;
				var zoom = 4;

				geocoder = new google.maps.Geocoder();
				var myLatlng = new google.maps.LatLng(lat, lng);
				var mapOptions = {
					zoom: zoom,
					center: myLatlng,
					disableDefaultUI: true,
					panControl: false,
					zoomControl: true,
					mapTypeControl: true,
					scaleControl: true,
					streetViewControl: false,
					overviewMapControl: true
				};

				map = new google.maps.Map(jQuery(element)[0], mapOptions);
				marker = new google.maps.Marker({
					// position: myLatlng,
					map: map,
					draggable: true,
					title:"Drag me!" 
				});

				google.maps.event.addListener(map, 'click', function(event) {
					marker.setPosition(event.latLng);
					marker.setMap(map);
				});	

				google.maps.event.addListener(marker, 'position_changed', function() {
					ngModelCtrl.$setViewValue(marker.getPosition().toUrlValue());
					// scope.$apply();
				});
			}

			var parseCoordinates = function(value) {
				var coordinates = typeof value == 'string' ? value.split(',') : '';
				if (coordinates.length == 2) {
					return coordinates;
				} else {
					return false;
				}
			}

			var setCenterAndMarker = function(lat, lng, zoom)
			{
				zoom = zoom || 16;
				var latlng = new google.maps.LatLng(lat,lng);
				map.setCenter(latlng);
				map.setZoom(zoom);
				marker.setPosition(latlng);
				marker.setMap(map);
			}

			initialize();

			var init = false;

			scope.$watch(function() {
				return ngModelCtrl.$viewValue;
			}, function(newVal, oldVal) {
				if (/*newVal != oldVal || */init == false) {
					var coords = parseCoordinates(newVal);
					if (coords) {
						setCenterAndMarker(coords[0], coords[1]);
					}
					init = true;
				}
			});

			scope.$watch(function() {
				return scope.address;
			}, function(newVal, oldVal) {
				if (newVal != oldVal) {
					geocoder.geocode({'address': newVal}, function(results, status) {
						if (status == google.maps.GeocoderStatus.OK) {
							map.setCenter(results[0].geometry.location);
							map.setZoom(16);
							marker.setMap(map);
							marker.setPosition(results[0].geometry.location);
						} else {
							// alert('Geocode was not successful for the following reason: ' + status);
						}
					});
				}
			});
		}
	}
});

storelocator.filter('orderObjectBy', function() {
 return function(input, attribute, direction) {
    if (!angular.isObject(input)) return input;

    var array = [];
    var keys = [];
    for(var objectKey in input) {
    	array.push(input[objectKey]);
    	keys.push(objectKey);
    }

    array.sort(function(a, b){
        a = a[attribute];
        b = b[attribute];
        var r = direction == 'desc' ? b - a : a - b;
        return r;
    });

    var object = {};
    for (var key in array) {
    	object[keys[key]] = array[key];
    }
    
    return array;
 }
});

jQuery(document).ready(function() {
	jQuery('.ngg_admin_notice').remove();
});

var $ = jQuery;