<?php

Class DLStoreLocator
{
	public static $tableNameItems;
	public static $tableNameSections;
	public static $tableNameIcons;
	public static $uploadPathFull;
	public static $uploadPathBase;
	public static $uploadUrlBase;

	public static function init()
	{
		global $wpdb;

		if (!function_exists('wp_upload_dir'))
        {
            include(ABSPATH . "wp-includes/pluggable.php"); 
        }
		$upload_dir = wp_upload_dir();

		self::$tableNameItems = $wpdb->prefix . DL_PREFIX . "store_locator_items";
		self::$tableNameSections = $wpdb->prefix . DL_PREFIX . "store_locator_sections";
		self::$tableNameIcons = $wpdb->prefix . DL_PREFIX . "store_locator_icons";
		self::$uploadPathFull = $upload_dir['path'];
		self::$uploadPathBase = $upload_dir['basedir'];
		self::$uploadUrlBase = $upload_dir['baseurl'];

		add_shortcode('plumo_mapnpoints', array('DLStoreLocator', 'widget'));

		add_action('admin_menu', array('DLStoreLocator', 'addSettingsMenu'));
		add_action('admin_print_scripts', array('DLStoreLocator', 'addHeadStyles'));
		add_action('admin_print_scripts', array('DLStoreLocator', 'addHeadScripts'));
		add_action('plugins_loaded', array('DLStoreLocator', 'loadTextDomain'));

		add_filter( "mce_external_plugins", array('DLStoreLocator', 'addEditorButtons') );
    	add_filter( 'mce_buttons', array('DLStoreLocator', 'registerEditorButtons') );

    	add_filter( 'mce_external_languages',  array('DLStoreLocator', 'registerEditorLang') , 10, 1 );

	}

	public static function registerEditorLang( $arr )
	{
	  	$arr[] = DL_STORELOCATOR_DIR . 'editorplugin/lang.php';
	  	
		return $arr;
	}
	public static function addEditorButtons( $plugin_array )
	{
		$plugin_array['dlslp'] = DL_STORELOCATOR_URL . 'editorplugin/dl-plugin.js';
		return $plugin_array;
	}

	public static function registerEditorButtons( $buttons )
	{
		array_push( $buttons, 'addstoreloc'); 

		return $buttons;
	}

	public static function loadTextDomain() {
		load_plugin_textdomain( 'dl-store-locator', false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
	}

	public static function recurse_copy($src, $dst) { 
	    $dir = opendir($src); 
	    @mkdir($dst); 
	    while(false !== ( $file = readdir($dir)) ) { 
	        if (( $file != '.' ) && ( $file != '..' )) { 
	            if ( is_dir($src . '/' . $file) ) { 
	                recurse_copy($src . '/' . $file,$dst . '/' . $file); 
	            } 
	            else { 
	                copy($src . '/' . $file,$dst . '/' . $file); 
	            } 
	        } 
	    } 
	    closedir($dir); 
	}

	public static function activation()
	{
		global $wpdb;

	    // global $dl_store_locator_db_version;

	    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

	    if ($wpdb->get_var("show tables like '".self::$tableNameItems."'") != self::$tableNameItems)
	    {
	        $sql = "CREATE TABLE " . self::$tableNameItems . " (
	            id int(10) NOT NULL AUTO_INCREMENT,
	            active int(1) DEFAULT '1' NOT NULL,
	            name VARCHAR(500) NOT NULL,
	            sort int(10) DEFAULT '500' NOT NULL,
	            email VARCHAR(500) NOT NULL,
	            address VARCHAR(500) NOT NULL,
	            work_time VARCHAR(1000) NOT NULL,
	            work_time_text VARCHAR(500) NOT NULL,
	            group_name VARCHAR(500) NOT NULL,
	            icon int(6) NOT NULL,
	            coordinates VARCHAR(500) NOT NULL,
	            url VARCHAR(500) NOT NULL,
	            phone VARCHAR(500) NOT NULL,
	            transport VARCHAR(500) NOT NULL,
	            description TEXT NOT NULL,
	            image VARCHAR(1000) NOT NULL,
	            section_id int(6) NOT NULL,
	            logo VARCHAR(1000) NOT NULL,
	            UNIQUE KEY id (id)
	        );";

	        dbDelta($sql);
	        $rowsAffected = $wpdb->insert(self::$tableNameItems);

	        $demoInsertSql = file_get_contents(DL_STORELOCATOR_DIR . 'demo/sql/dl_store_locator_items.sql');
			$sql = "INSERT INTO " . self::$tableNameItems . " " . $demoInsertSql;
			$wpdb->query($sql);

			DLStoreLocator::recurse_copy(DL_STORELOCATOR_DIR . 'demo/images/', self::$uploadPathBase . '/map-n-points');
	    }

	    if ($wpdb->get_var("show tables like '".self::$tableNameSections."'") != self::$tableNameSections)
	    {
	        $sql = "CREATE TABLE " . self::$tableNameSections . " (
	            id mediumint(9) NOT NULL AUTO_INCREMENT,
	            active int(1) DEFAULT '1' NOT NULL,
	            name VARCHAR(500) NOT NULL,
	            sort int(10) DEFAULT '500' NOT NULL,
	            UNIQUE KEY id (id)
	        );";

			$demoInsertSql = file_get_contents(DL_STORELOCATOR_DIR . 'demo/sql/dl_store_locator_sections.sql');

			$sql .= "INSERT INTO " . self::$tableNameSections . " " . $demoInsertSql;

			// $sql .= "INSERT INTO " . self::$tableNameSections . " (name) VALUES ('Default');";

	        dbDelta($sql);

	        $rowsAffected = $wpdb->insert(self::$tableNameSections);
	    }

	    if ($wpdb->get_var("show tables like '".self::$tableNameIcons."'") != self::$tableNameIcons)
	    {
	        $sql = "CREATE TABLE " . self::$tableNameIcons . " (
	            id mediumint(9) NOT NULL AUTO_INCREMENT,
	            active int(1) DEFAULT '1' NOT NULL,
	            name VARCHAR(500) NOT NULL,
	            src VARCHAR(1000) NOT NULL,
	            sort int(10) DEFAULT '500' NOT NULL,
	            infobox_color VARCHAR(100) DEFAULT '#ffffff' NOT NULL,
	            UNIQUE KEY id (id)
	        );";

			$demoInsertSql = file_get_contents(DL_STORELOCATOR_DIR . 'demo/sql/dl_store_locator_icons.sql');

			$sql .= "INSERT INTO " . self::$tableNameIcons . " " . $demoInsertSql;

			// $sql .= "INSERT INTO " . self::$tableNameIcons . " (name, src) VALUES ('Default', '" . DL_STORELOCATOR_URL . "icons/icon-1.png');";

	        dbDelta($sql);

	        $rowsAffected = $wpdb->insert(self::$tableNameIcons);
	    }

	    // Default options
	    $options = array(
	    	'template' => 'right',
	    	'infobox_header_align' => 'left',
	    	'list_show_icon' => true,
	    	'list_show_image' => true,
	    	'list_show_info' => true,
	    	'show_type_filter' => false,
	    	'color_scheme' => array(
	    		'title' => 'Custom',
	    		'header_color' => '#455a64',
		    	'text_color' => '#607d8b',
		    	'link_color' => '#00b0ff',
		    	'background_color' => '#ffffff',
		    	'hover_color' => '#cfd8dc',
		    	'scroll_color' => '#eceff1',
		    	'sort' => 5
    		)
	    );
	    
	    add_option(DL_PREFIX . 'store_locator', $options, '', 'yes');

	    // add_option("dl_store_locator_db_version", $dl_store_locator_db_version);
	}

	public static function getOptions($arOptions = array())
	{
		return get_option(DL_PREFIX . 'store_locator');
	}

	public static function updateOptions($arUpdate = array(), $clear = false)
	{
		$arOptions = get_option(DL_PREFIX . 'store_locator');

		if ($clear == false)
		{
			foreach ($arUpdate as $key => $val)
			{
				$arOptions[$key] = $val;
			}
		}
		else
		{
			$arOptions = $arUpdate;
		}

		return update_option(DL_PREFIX . 'store_locator', $arOptions);
	}

	public static function addHeadScripts()
	{
		if (is_admin()) {
			wp_deregister_script('angular');
		    wp_register_script('angular', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.3.11/angular.min.js');
		    wp_enqueue_script('angular');
		    wp_enqueue_script('angular_resource', "https://ajax.googleapis.com/ajax/libs/angularjs/1.2.24/angular-resource.min.js", "angular");
		    wp_enqueue_script('angular_route', "https://ajax.googleapis.com/ajax/libs/angularjs/1.2.24/angular-route.min.js", "angular");
		    wp_enqueue_script('angular_sanitize', "https://ajax.googleapis.com/ajax/libs/angularjs/1.2.24/angular-sanitize.min.js", "angular");
		    wp_enqueue_script('angular-file-upload', DL_STORELOCATOR_URL . "js/angular-file-upload.min.js", "angular");
		    wp_enqueue_script(DL_PREFIX . 'store_locator', DL_STORELOCATOR_URL . "js/admin.js", "jQuery");
		    wp_enqueue_script(DL_PREFIX . 'select2', DL_STORELOCATOR_URL . "js/select2.min.js", "jQuery");
		    wp_enqueue_script(DL_PREFIX . 'multiple', DL_STORELOCATOR_URL . "js/jquery.multiple.select.js", "jQuery");
		    wp_enqueue_script('google_maps', 'https://maps.googleapis.com/maps/api/js?v=3.exp');
		    wp_enqueue_script('wp-color-picker');
		    wp_enqueue_script(DL_PREFIX . 'store_locator', DL_STORELOCATOR_URL . "js/jquery.min.js", "jQuery");

		    $nonce = wp_create_nonce(DL_PREFIX . 'store_locator');

		    $l10n = array(
				"Info" => __('Info', 'dl-store-locator'),
				"Title" => __('Title', 'dl-store-locator'),
				"Url" => __('Website URL', 'dl-store-locator'),
				"Phone" => __('Phone number', 'dl-store-locator'),
				"WorkTime" => __('Opening time', 'dl-store-locator'),
				"WorkTimeComment" => __('Comment for opening time', 'dl-store-locator'),
				"Type" => __('Type', 'dl-store-locator'),
				"Address" => __('Display address', 'dl-store-locator'),
				"Section" => __('Section', 'dl-store-locator'),
				"Coordinates" => __('Point', 'dl-store-locator'),
				"searchForAddress" => __('Search point by address', 'dl-store-locator'),
				"Search" => __('Search', 'dl-store-locator'),
				"Description" => __('Description', 'dl-store-locator'),
				"Display" => __('Display', 'dl-store-locator'),
				"Active" => __('Active', 'dl-store-locator'),
				"Sort" => __('Sort', 'dl-store-locator'),
				"Image" => __('Image', 'dl-store-locator'),
				"ID" => __('ID', 'dl-store-locator'),
				"AddSection" => __('Add Section', 'dl-store-locator'),
				"Active" => __('Active', 'dl-store-locator'),
				"Cancel" => __('Cancel', 'dl-store-locator'),
				"UpdateItem" => __('Update item', 'dl-store-locator'),
				"AddItem" => __('Add item', 'dl-store-locator'),
				"EditSection" => __('Edit section', 'dl-store-locator'),
				"UpdateSection" => __('Update section', 'dl-store-locator'),
				"InfoboxHeaderBackgroundColor" => __('Infobox header background color (if the point has no image)', 'dl-store-locator'),
				"Icon" => __('Marker', 'dl-store-locator'),
				"AddType" => __('Add type', 'dl-store-locator'),
				"EditType" => __('Edit type', 'dl-store-locator'),
				"UpdateType" => __('Update type', 'dl-store-locator'),
				"Edit" => __('Edit', 'dl-store-locator'),
				"Delete" => __('Delete', 'dl-store-locator'),
				"EditThisItem" => __('Edit this point', 'dl-store-locator'),
				"DeleteThisItem" => __('Delete this point', 'dl-store-locator'),
				"EditThisType" => __('Edit this type', 'dl-store-locator'),
				"DeleteThisType" => __('Delete this type and all associated items', 'dl-store-locator'),
				"EditThisSection" => __('Edit this section', 'dl-store-locator'),
				"DeleteThisSection" => __('Delete this section and all associated items', 'dl-store-locator'),
				"AreYouSure" => __('Are you sure?', 'dl-store-locator'),
				"AreYouSureType" => __('Are you sure? All items with this type will be deleted.', 'dl-store-locator'),
				"AreYouSureSection" => __('Are you sure? All items from this section will be deleted.', 'dl-store-locator'),
				"From" => __('From', 'dl-store-locator'),
				"To" => __('To', 'dl-store-locator'),
				"Sunday" => __('Sun', 'dl-store-locator'),
				"Monday" => __('Mon', 'dl-store-locator'),
				"Tuesday" => __('Tue', 'dl-store-locator'),
				"Wednesday" => __('Wed', 'dl-store-locator'),
				"Thursday" => __('Thu', 'dl-store-locator'),
				"Friday" => __('Fri', 'dl-store-locator'),
				"Saturday" => __('Sat', 'dl-store-locator'),
				"items" => _x('items', 'paginator', 'dl-store-locator'),
				"of" => __('of', 'dl-store-locator'),
				"mapleft" => __('map is on the left', 'dl-store-locator'),
				"mapRight" => __('map is on the right', 'dl-store-locator'),
				"mapTop" => __('map is on top', 'dl-store-locator'),
				"alignLeft" => _x('left', 'align', 'dl-store-locator'),
				"alignCenter" => _x('center', 'align', 'dl-store-locator'),
				"alignRight" => _x('right', 'align', 'dl-store-locator'),
				"selectAll" => __('Select all days', 'dl-store-locator'),
				"allSelected" => __('All days selected', 'dl-store-locator'),
				"noMatchesFound" => __('No matches found', 'dl-store-locator'),
				"numOfNumSelected" => __('# of % selected', 'dl-store-locator'),
				"selectDays" => __('Select days', 'dl-store-locator'),
				"sectionsHelp" => __('On this page you can manage sections. Most often (but not always), sections are used for the separation points by countries, cities and districts. Sections are displayed in select box and work as a switch set points of different <a href="/wp-admin/admin.php?page=dlstorelocatoricons#/icon/list">types</a> are displayed in the list and on the map.', 'dl-store-locator'),
				"typesHelp" => __('On this page you can manage types. Types allow you to display different point markers on a map. Types (marker and captions for it) also displayed in map legend. Legend work as points filter in one <a href="/wp-admin/admin.php?page=dlstorelocatorsections#/section/list">section</a>. For example, you can use this functionality for the separation stores and service center of same network and display it by different markers. And <a href="/wp-admin/admin.php?page=dlstorelocatorsections#/section/list">sections</a> you can use for separation points by the countries, cities and districts (higher levels of grouping).', 'dl-store-locator'),
				"itemsHelp" => __('On this page you can manage your points. Points are displayed on map as marker and in list. All points have a set of fields (address, phone number, opening times, etc). Point belongs to the <a href="/wp-admin/admin.php?page=dlstorelocatorsections#/section/list">sections</a> and have one of the <a href="/wp-admin/admin.php?page=dlstorelocatoricons#/icon/list">types</a>.', 'dl-store-locator'),
				"showHelp" => __('Show help', 'dl-store-locator'),
				"hideHelp" => __('Hide help', 'dl-store-locator'),
				"Help" => __('HowTo', 'dl-store-locator'),
				"HelpText" => __('Use shortcode [plumo_mapnpoints] in your post or page. Also you can use Map’n’Points button in WYSIWYG editor.<br><br> If you have any question, you can ask it on our <a href=\"http://codecanyon.net/user/plumoteam\">CodeCanyon page</a>. We are happy to help you!', 'dl-store-locator'),
				"addNewSection" => __('Add new section', 'dl-store-locator'),

		    );

		    wp_localize_script(DL_PREFIX . 'store_locator', 'DL', array('ajaxurl' => admin_url('admin-ajax.php') . "?_wpnonce=$nonce", 'prefix' => DL_PREFIX, 'url' => DL_STORELOCATOR_URL, 'upload_dir' => self::$uploadUrlBase, 'l10n' => $l10n));

		}
	}

	public static function addHeadStyles()
	{
		if (is_admin()) {
			wp_enqueue_style(DL_PREFIX . 'store_locator', DL_STORELOCATOR_URL . "css/admin.css");
			wp_enqueue_style(DL_PREFIX . 'select2', DL_STORELOCATOR_URL . "css/select2.min.css");
			wp_enqueue_style(DL_PREFIX . 'multiple', DL_STORELOCATOR_URL . "css/multiple-select.css");			
	        wp_enqueue_style('wp-color-picker');
		}
	}

	public static function addSettingsMenu()
	{
		add_menu_page(
			__('Map’n’Points', 'dl-store-locator'),
			__('Map’n’Points', 'dl-store-locator'),
			'manage_options',
			'dlstorelocator',
			array('DLStoreLocator', 'showSettingsPage'),
			DL_STORELOCATOR_URL . 'images/admin_menu_icon.png'
		);

		add_submenu_page(
			'dlstorelocator',
			__('Points', 'dl-store-locator'),
			__('Points', 'dl-store-locator'),
			'manage_options',
			'dlstorelocator',
			array('DLStoreLocator', 'showSettingsPage')
		);

		add_submenu_page(
			'dlstorelocator',
			__('Sections', 'dl-store-locator'),
			__('Sections', 'dl-store-locator'),
			'manage_options',
			'dlstorelocatorsections',
			array('DLStoreLocator', 'showSectionsPage')
		);

		add_submenu_page(
			'dlstorelocator',
			__('Types', 'dl-store-locator'),
			__('Types', 'dl-store-locator'),
			'manage_options',
			'dlstorelocatoricons',
			array('DLStoreLocator', 'showIconsPage')
		);

		add_submenu_page(
			'dlstorelocator',
			__('Design', 'dl-store-locator'),
			__('Design', 'dl-store-locator'),
			'manage_options',
			'dlstorelocatorsettings',
			array('DLStoreLocator', 'showOptionsPage')
		);
		add_submenu_page(
			'dlstorelocator',
			__('HowTo', 'dl-store-locator'),
			__('HowTo', 'dl-store-locator'),
			'manage_options',
			'dlstorelocatorhelp',
			array('DLStoreLocator', 'showHelpPage')
		);
	}

	public static function showSettingsPage()
	{
		include DL_STORELOCATOR_DIR . 'views/settings.php';
	}

	public static function showOptionsPage()
	{
		include DL_STORELOCATOR_DIR . 'views/options.php';
	}

	public static function showHelpPage()
	{
		include DL_STORELOCATOR_DIR . 'views/help.php';
	}

	public static function showSectionsPage()
	{
		include DL_STORELOCATOR_DIR . 'views/sections.php';
	}

	public static function showIconsPage()
	{
		include DL_STORELOCATOR_DIR . 'views/icons.php';
	}

	public static function securityCheck()
	{
		if (!isset($_REQUEST['_wpnonce']))
		{
			die();
		}

		$nonce = $_REQUEST['_wpnonce'];

		if (!function_exists('wp_verify_nonce'))
		{
			require_once(ABSPATH .'wp-includes/pluggable.php');
		}

		if (!wp_verify_nonce($nonce, 'dl_store_locator'))
		{
			die(0);
		}
	}

	public static function _prepareColumns($tableName, &$fields)
	{
		global $wpdb;

		$cols = $wpdb->get_col("DESC " . $tableName, 0);

		foreach ($fields as $field => $value)
		{
			if (!in_array($field, $cols))
			{
				unset($fields[$field]);
			}
		}
	}

	public static function getItems()
	{
		global $wpdb;

		$arItems = $wpdb->get_results("SELECT * FROM ".self::$tableNameItems." ORDER BY sort ASC", ARRAY_A);

		foreach ($arItems as &$item)
		{
			foreach ($item as $key => &$field)
			{
				if (is_serialized($field))
				{
					$field = maybe_unserialize($field);
				}
			}
		}

		return $arItems;
	}

	public static function getSections()
	{
		global $wpdb;

		$arSections = $wpdb->get_results("SELECT * FROM ".self::$tableNameSections." ORDER BY sort ASC", ARRAY_A);

		return $arSections;
	}

	public static function getIcons()
	{
		global $wpdb;

		$defaultIcons = self::getDefaultIcons();

		$arIcons = $wpdb->get_results("SELECT * FROM ".self::$tableNameIcons." ORDER BY sort ASC", ARRAY_A);

		foreach ($arIcons as $key => $value) {
			if( in_array($value['src'], $defaultIcons) )
			{
				$arIcons[$key]['isDefault'] = 1;
			}
			else
			{
				$arIcons[$key]['isDefault'] = 0;
			}
		}

		return $arIcons;
	}

	public static function getDefaultIcons()
	{
		if (!function_exists('wp_get_current_user'))
        {
            include(ABSPATH . "wp-includes/pluggable.php"); 
        }

		$iconsDir = dirname(__FILE__) . '/icons/';
		$arFiles = scandir($iconsDir);

		$arIcons = array();
		foreach ($arFiles as $key => $filename)
		{
			$filetype = wp_check_filetype($iconsDir . $filename);
			if ($filetype['ext'] == 'png')
			{
				$arIcons[] = '/icons/' . $filename;
			}
		}

		return $arIcons;
	}

	public static function getAllData( $idAsKeys = false, $filterActive = false )
	{
		
		$startOfWeek = (int) get_option('start_of_week', 0);
		$defaultIcons = self::getDefaultIcons();

		$usedSections = array();
		$retArr = array(
			'items'		=> self::getItems(),
			'sections'	=> self::getSections(),
			'icons'		=> self::getIcons()
		);
		if( $idAsKeys )
		{
			$tmpArr = array();
			foreach ($retArr as $key => $arr) {
				foreach ($arr as $subKey => $subArr) {
					$tmpArr[$key][$subArr['id']] = $subArr;
				}
			}
			$retArr = $tmpArr;
		}
		$days = array(
			'0' => __('Sun', 'dl-store-locator'),
			'1' => __('Mon', 'dl-store-locator'),
			'2' => __('Tue', 'dl-store-locator'),
			'3' => __('Wed', 'dl-store-locator'),
			'4' => __('Thu', 'dl-store-locator'),
			'5' => __('Fri', 'dl-store-locator'),
			'6' => __('Sat', 'dl-store-locator'),
		);
		foreach($retArr['items'] as $itemKey => $item) {
			$usedSections[] = $item['section_id'];
			if( $filterActive && $item['active'] == 0 )
			{
				unset($retArr['items'][$itemKey]);
				continue;
			}
			if( $item['url'] )
			{
				$url = parse_url($item['url']);
				if( !$url['scheme'] )
				{
					$resUrl = 'http://'. $item['url'];
				}
				else
				{
					$resUrl = $item['url'];
				}

				$display = preg_replace("@^https?://@", "", ($item['url']));
				$display = explode("/", $display);
				$display = $display[0];

				$retArr['items'][$itemKey]['url'] = array(
					'href' => $resUrl,
					'display' => $display
				);
			}
			if( is_array($item['work_time']) )
			{	
				$sortedTime	= array();
				$displayTime = array();
				foreach ($item['work_time'] as $timeKey => $timeArr) {
					if( isset($timeArr['day']) && is_array($timeArr['day']) )
					{
						foreach ($timeArr['day'] as $dayKey => $day) {
							$sortedTime[$day] = array(
								'from'	=> $timeArr['from'],
								'to'	=> $timeArr['to']
							);
						}
					}
				}
				
				for ($i=0; $i <= 6; $i++) { 
					if( !isset($sortedTime[$i]) )
					{
						$sortedTime[$i] = array(
							'from'	=> __('closed', 'dl-store-locator'),
							'to'	=> __('closed', 'dl-store-locator')
						);
					}
				}
				ksort($sortedTime);
				$sortedTimeByDays = array();
				foreach ($sortedTime as $day => $time) {
					$sortedTimeByDays[$days[$day]] = $time;
					$sortedTimeByDays[$days[$day]]['dayNum'] = $day;
				}


				if ( $startOfWeek) {
					$tmpDaysArr = array_splice($sortedTimeByDays, 0, $startOfWeek);
					$sortedTimeByDays = array_merge($sortedTimeByDays, $tmpDaysArr);
				}

				foreach ($sortedTimeByDays as $day => $time) {
					$lastElement = end($displayTime);
					$displayTimeKeys = array_keys($displayTime);
					$lastElementKey = end($displayTimeKeys);
					if( $time['from'] == __('closed', 'dl-store-locator') && $time['to'] == __('closed', 'dl-store-locator'))
					{
						$work_time = __('closed', 'dl-store-locator');
					}
					else
					{
						$work_time = $time['from'] . " - " . $time['to'];
					}
					if( $lastElementKey === false )
					{
						$displayTime[] = array(
							'from' => $day,
							'time' => $work_time,
							'time_from' => $time['from'],
							'time_to' => $time['to'],
							'dayNums' => array($time['dayNum'])
						);

					}
					else
					{
						if( $displayTime[$lastElementKey]['time'] == $work_time )
						{
							$displayTime[$lastElementKey]['to'] = $day;
							$displayTime[$lastElementKey]['dayNums'][] = $time['dayNum'];
						}
						else
						{
							$displayTime[] = array(
								'from' => $day,
								'time' => $work_time,
								'time_from' => $time['from'],
								'time_to' => $time['to'],
								'dayNums' => array($time['dayNum'])
							);
						}
					}
				}
				$retArr['items'][$itemKey]['work_time_sorted'] = $sortedTime;
				$retArr['items'][$itemKey]['work_time_display'] = $displayTime;
			}

			if( $item['image'] != '' )
			{
				$retArr['items'][$itemKey]['image'] = self::$uploadUrlBase . $item['image'];
			}
		}
		$usedSections = array_unique($usedSections);
		foreach($retArr['sections'] as $sectionKey => $section) {

			if( !in_array($section['id'], $usedSections)  || ($filterActive && $section['active'] == 0) )
			{
				unset($retArr['sections'][$sectionKey]);
			}
		}
		foreach($retArr['icons'] as $iconKey => $icon) {

			if( !in_array($icon['src'], $defaultIcons)  )
			{
				$retArr['icons'][$iconKey]['src'] = self::$uploadUrlBase . $icon['src'];
			}
			else
			{
				$retArr['icons'][$iconKey]['src'] = DL_STORELOCATOR_URL . $icon['src'];
			}
		}
		return $retArr;
	}

	public static function addItem($arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameItems, $arFields);

		foreach ($arFields as $key => &$field)
		{
			if (is_array($field))
			{
				$field = maybe_serialize($field);
			}
		}

		$wpdb->insert(
			self::$tableNameItems,
			$arFields
		);

		return $wpdb->insert_id;
	}

	public static function addSection($arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameSections, $arFields);

		$wpdb->insert(
			self::$tableNameSections,
			$arFields
		);

		return $wpdb->insert_id;
	}

	public static function addIcon($arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameIcons, $arFields);

		$wpdb->insert(
			self::$tableNameIcons,
			$arFields
		);

		return $wpdb->insert_id;
	}

	public static function updateItem($id, $arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameItems, $arFields);

		foreach ($arFields as $key => &$field)
		{
			if (is_array($field))
			{
				$field = maybe_serialize($field);
			}
		}

		$result = $wpdb->update(
			self::$tableNameItems,
			$arFields,
			array('id' => $id)
		);
		
		if( $result !== false )
		{
			$result = 1;
		}
		return $result;

	}

	public static function updateSection($id, $arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameSections, $arFields);

		$result =  $wpdb->update(
			self::$tableNameSections,
			$arFields,
			array('id' => $id)
		);

		if( $result !== false )
		{
			$result = 1;
		}
		return $result;
	}

	public static function updateIcon($id, $arFields)
	{
		global $wpdb;

		DLStoreLocator::_prepareColumns(DLStoreLocator::$tableNameIcons, $arFields);
		$result = $wpdb->update(
			self::$tableNameIcons,
			$arFields,
			array('id' => $id)
		);
		if( $result !== false )
		{
			$result = 1;
		}
		return $result;
	}

	public static function deleteItem($fields)
	{
		global $wpdb;

		foreach ($fields as $key => $val)
		{
			$result = $wpdb->query(
				$wpdb->prepare(
					"DELETE FROM " . self::$tableNameItems ." WHERE ".$key." = %d",
			        intval($val)
		        )
			);
		}

		return $result;
	}

	public static function deleteSection($fields)
	{
		global $wpdb;

		foreach ($fields as $key => $val)
		{
			$result = $wpdb->query(
				$wpdb->prepare(
					"DELETE FROM " . self::$tableNameSections ." WHERE ".$key." = %d",
			        intval($val)
		        )
			);
		}

		return $result;
	}

	public static function deleteIcon($fields)
	{
		global $wpdb;

		foreach ($fields as $key => $val)
		{
			$result = $wpdb->query(
				$wpdb->prepare(
					"DELETE FROM " . self::$tableNameIcons ." WHERE ".$key." = %d",
			        intval($val)
		        )
			);
		}

		return $result;
	}

	public static function uploadImage($width, $height)
	{
		if (!function_exists('wp_get_current_user'))
        {
            include(ABSPATH . "wp-includes/pluggable.php"); 
        }

        if (!function_exists('wp_handle_upload'))
        {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }

        $movefile = wp_handle_upload($_FILES['file'], array('test_form' => false));

        if ($movefile && !isset($movefile['error']))
        {
            $image = wp_get_image_editor($movefile['file']);

            if (!is_wp_error($image))
            {
                $image->resize($width, $height);
                $image->save($movefile['file']);
            }

            preg_match('/http:\/\/([^\/]*)\/(.*)/', $movefile['url'], $matches);
            $movefile['src'] = '/' . $matches[2];
            $movefile['relativePath'] = str_replace(self::$uploadPathBase, '', $movefile['file']);
            return $movefile;
        }
	}

	public static function processTemplate($templateData)
	{
		var_dump($templateData);
		$tpl = file_get_contents(DL_STORELOCATOR_DIR . 'css/tpl.css');
		$search = array(
			'#mainColorLightText#',
			'#linkColor#',
			'#bgcolor#',
			'#mainColorDark#',
			'#mainColorMoreLight#',
			'#mainColorLight#'
		);
		$replace = array(
			$templateData['text_color'],
			$templateData['link_color'],
			$templateData['background_color'],
			$templateData['header_color'],
			$templateData['hover_color'],
			$templateData['scroll_color']
		);
		$tpl = str_replace($search, $replace, $tpl);
		$output = '/* Auto generated, do not modify. All changes will be lost after settings updates in WP admin panel. */' . PHP_EOL . $tpl;
		file_put_contents( DL_STORELOCATOR_DIR . 'css/current.css', $output );
	}

	public static function widget()
	{
		ob_start();
		$DL_Data = self::getAllData(true, true);
		$options = self::getOptions();
		$mtime = file_exists( DL_STORELOCATOR_DIR . 'css/current.css' ) ? filemtime( DL_STORELOCATOR_DIR . 'css/current.css' ) : '1';
		$custom_mtime = file_exists( DL_STORELOCATOR_DIR . 'css/custom.css' ) ? filemtime( DL_STORELOCATOR_DIR . 'css/custom.css' ) : '1';
		wp_enqueue_style(DL_PREFIX . 'store_locator_widget', DL_STORELOCATOR_URL . "css/current.css?t=". $mtime);
        wp_enqueue_style(DL_PREFIX . 'store_locator_widget_custom', DL_STORELOCATOR_URL . "css/custom.css?t=". $custom_mtime);
		wp_enqueue_script( 'gmaps', 'https://maps.googleapis.com/maps/api/js?v=3.exp' );
		wp_enqueue_script( 'jscrollpane', plugin_dir_url( __FILE__ ) . 'js/jquery.jscrollpane.min.js', array('jquery') );
		wp_enqueue_script( 'mousewheel', plugin_dir_url( __FILE__ ) . 'js/jquery.mousewheel.min.js', array('jquery') );
		wp_enqueue_script( 'chosen', plugin_dir_url( __FILE__ ) . 'js/chosen.jquery.js', array('jquery') );
		wp_enqueue_script( 'infobox', plugin_dir_url( __FILE__ ) . 'js/infobox.js' , array('gmaps') );
		wp_enqueue_script( 'clusterer', plugin_dir_url( __FILE__ ) . 'js/markerclusterer_compiled.js' , array('gmaps') );
		wp_enqueue_script( DL_PREFIX . 'storeloc_main', plugin_dir_url( __FILE__ ) . 'js/script.js', array( 'gmaps', 'jscrollpane', 'mousewheel', 'chosen', 'infobox', 'clusterer', 'jquery' ) );
		wp_localize_script( DL_PREFIX . 'storeloc_main', 'dl', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ), 'Prefix' => DL_PREFIX, 'Url' => DL_STORELOCATOR_URL ) );
		wp_localize_script( DL_PREFIX . 'storeloc_main', 'dloptions', $options );

		include DL_STORELOCATOR_DIR . 'views/widget.php';
		return ob_get_clean();
	}
}

?>