<?php
/*
Plugin Name: Connections cMap - Template
Plugin URI: http://www.connections-pro.com
Description: Connections cMap - Template
Version: 5.1
Author: Steven A. Zahm
Author URI: http://www.connections-pro.com
Text Domain: cnt_cmap
Domain Path: /languages

Copyright 2013  Steven A. Zahm  (email : shazahm1@hotmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if ( ! class_exists( 'CN_cMap' ) ) {

	class CN_cMap {

		const VERSION = '5.1';

		const SLUG = 'cmap';

		/**
		 * Stores a copy of the shortcode $atts for use throughout the class.
		 *
		 * @access private
		 * @since 3.0
		 * @var (array)
		 */
		private static $atts;

		/**
		 * Stores an initialized instance of cnTemplate.
		 *
		 * @access private
		 * @since 3.0
		 * @var (object)
		 */
		private static $template;

		/**
		 * Setup the template.
		 *
		 * @access public
		 * @since 3.0
		 * @param cnTemplate $template An initialized instance of the cnTemplate class.
		 */
		public function __construct( $template ) {

			self::$template = $template;

			if ( ! is_admin() ) {

				// Register the required JS file.
				add_filter( 'cn_template_required_js-' . $template->getSlug(), array( __CLASS__, 'enqueueJS' ) );

				// Update the permitted shortcode attribute the user may use and override the template defaults as needed.
				add_filter( 'cn_list_atts_permitted-' . $template->getSlug(), array( __CLASS__, 'initShortcodeAtts') );
				add_filter( 'cn_list_atts-' . $template->getSlug(), array( __CLASS__, 'initTemplateOptions') );

				add_action( 'cn_template_enqueue_css-' . $template->getSlug(), array( __CLASS__, 'inlineStyle' ) );
			}
		}

		/**
		 * Register the template with the Template API and define it's supported features.
		 *
		 * @access private
		 * @since  unknown
		 */
		public static function register() {

			self::defineConstants();

			/**
			 * NOTE: Any calls to load_plugin_textdomain should be in a function attached to the `plugins_loaded` action hook.
			 * @link http://ottopress.com/2013/language-packs-101-prepwork/
			 *
			 * NOTE: The `cn_register_template` action hook is fired on the `plugins_loaded` action hook.
			 */
			self::loadTextdomain();

			$atts = array(
				'class'       => __CLASS__,
				'name'        => 'cMap',
				'slug'        => self::SLUG,
				'type'        => 'all',
				'version'     => self::VERSION,
				'author'      => 'Steven A. Zahm',
				'authorURL'   => 'connections-pro.com',
				'description' => __( 'Features a slide out Google Map.', 'cnt_cmap' ),
				'path'        => plugin_dir_path( __FILE__ ),
				'url'         => plugin_dir_url( __FILE__ ),
				'thumbnail'   => 'thumbnail.png',
				'supports'    => array(
					'customizer' => array(
						'view' => array(
							'card'   => array(
								'display' => array(
									'title',
									'org',
									'dept',
									'contact_name',
									'family',
									'addresses',
									'phone_numbers',
									'email',
									'im',
									'social_media',
									'links',
									'dates',
									'bio',
									'notes',
									'categories',
									'last_updated',
									'return_to_top',
								),
								'image' => array(
									'type',
									'width',
									'height',
									'crop_mode',
									'fallback',
								),
								'strings' => array(
									'select' => array(
										'default' => __( 'Select Category', 'cnt_cmap' ),
										'label'   => __( 'The default select category label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'select_all' => array(
										'default' => __( 'Show All Categories', 'cnt_cmap' ),
										'label'   => __( 'The default select sll categories label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'contact_label' => array(
										'default' => __( 'Contact', 'cnt_cmap' ),
										'label'   => __( 'Contact Name Label', 'cnt_cmap ' ),
										'desc'    => '',
									),
									'map_show' => array(
										'default' => __( 'Show Map', 'cnt_cmap' ),
										'label'   => __( 'The show map content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'map_hide' => array(
										'default' => __( 'Close Map', 'cnt_cmap' ),
										'label'   => __( 'The hide map content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'bio_show' => array(
										'default' => __( 'Show Bio', 'cnt_cmap' ),
										'label'   => __( 'The show bio content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'bio_hide' => array(
										'default' => __( 'Close Bio', 'cnt_cmap' ),
										'label'   => __( 'The close bio content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'bio_head' => array(
										'default' => __( 'Biography', 'cnt_cmap' ),
										'label'   => __( 'The biography header text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'note_show' => array(
										'default' => __( 'Show Notes', 'cnt_cmap' ),
										'label'   => __( 'The show notes content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'note_hide' => array(
										'default' => __( 'Close Notes', 'cnt_cmap' ),
										'label'   => __( 'The close notes content tray label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'note_head' => array(
										'default' => __( 'Notes', 'cnt_cmap' ),
										'label'   => __( 'The notes header text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'category_label' => array(
										'default' => __( 'Categories: ', 'cnt_cmap' ),
										'label'   => __( 'The categories label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
								),
								'advanced' => array(
									'name_format',
									'contact_name_format',
									'address_format',
									'address_types',
									'email_format',
									'email_types',
									'phone_format',
									'phone_types',
									'link_format',
									'link_types',
									'date_format',
									'date_types'
								),
							),
							'single' => array(
								'display' => array(
									'title',
									'org',
									'dept',
									'contact_name',
									'family',
									'addresses',
									'phone_numbers',
									'email',
									'im',
									'social_media',
									'links',
									'dates',
									'bio',
									'notes',
									'categories',
									'last_updated',
									//'return_to_top',
								),
								'image' => array(
									'type',
									'width',
									'height',
									'crop_mode',
									'fallback',
								),
								'strings' => array(
									'contact_label' => array(
										'default' => __( 'Contact', 'cnt_cmap' ),
										'label'   => __( 'Contact Name Label', 'cnt_cmap ' ),
										'desc'    => '',
									),
									'bio_head' => array(
										'default' => __( 'Biography', 'cnt_cmap' ),
										'label'   => __( 'The biography header text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'note_head' => array(
										'default' => __( 'Notes', 'cnt_cmap' ),
										'label'   => __( 'The notes header text.', 'cnt_cmap' ),
										'desc'    => '',
									),
									'category_label' => array(
										'default' => __( 'Categories: ', 'cnt_cmap' ),
										'label'   => __( 'The categories label text.', 'cnt_cmap' ),
										'desc'    => '',
									),
								),
								'advanced' => array(
									'name_format',
									'contact_name_format',
									'address_format',
									'address_types',
									'email_format',
									'email_types',
									'phone_format',
									'phone_types',
									'link_format',
									'link_types',
									'date_format',
									'date_types'
								),
							),
						),
					),
					'search',
					'category-select',
					'pagination',
					'single',
				),
			);

			cnTemplateFactory::register( $atts );

			// License and Updater.
			if ( class_exists( 'cnLicense' ) ) {

				new cnLicense( __FILE__, 'cMap', self::VERSION, 'Steven A. Zahm' );
			}

			add_filter( 'cn_register_settings_fields', array( __CLASS__, 'registerSettingsDefaults' ) );
		}

		/**
		 * Define the constants.
		 *
		 * @access private
		 * @since  4.1
		 *
		 * @return void
		 */
		private static function defineConstants() {

			define( 'CNT_CMAP_DIR_NAME', plugin_basename( dirname( __FILE__ ) ) );
			define( 'CNT_CMAP_BASE_NAME', plugin_basename( __FILE__ ) );
			define( 'CNT_CMAP_BASE_PATH', plugin_dir_path( __FILE__ ) );
			define( 'CNT_CMAP_BASE_URL', plugin_dir_url( __FILE__ ) );
		}

		/**
		 * Load the plugin translation.
		 *
		 * Credit: Adapted from Ninja Forms / Easy Digital Downloads.
		 *
		 * @access private
		 * @since  4.1
		 *
		 * @uses   apply_filters()
		 * @uses   get_locale()
		 * @uses   load_textdomain()
		 * @uses   load_plugin_textdomain()
		 */
		public static function loadTextdomain() {

			// Plugin textdomain. This should match the one set in the plugin header.
			$domain = 'cnt_cmap';

			// Set filter for plugin's languages directory
			$languagesDirectory = apply_filters( "cn_{$domain}_languages_directory", CNT_CMAP_DIR_NAME . '/languages/' );

			// Traditional WordPress plugin locale filter
			$locale   = apply_filters( 'plugin_locale', get_locale(), $domain );
			$fileName = sprintf( '%1$s-%2$s.mo', $domain, $locale );

			// Setup paths to current locale file
			$local  = $languagesDirectory . $fileName;
			$global = WP_LANG_DIR . "/{$domain}/" . $fileName;

			if ( file_exists( $global ) ) {

				// Look in global `../wp-content/languages/{$domain}/` folder.
				load_textdomain( $domain, $global );

			} elseif ( file_exists( $local ) ) {

				// Look in local `../wp-content/plugins/{plugin-directory}/languages/` folder.
				load_textdomain( $domain, $local );

			} else {

				// Load the default language files
				load_plugin_textdomain( $domain, FALSE, $languagesDirectory );
			}
		}

		/**
		 * Enqueue the template's JS file.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param array $required
		 *
		 * @return array
		 */
		public static function enqueueJS( $required ) {

			$required[] = 'jquery-chosen';
			$required[] = 'jquery-gomap';

			return $required;
		}

		/**
		 * Save the template settings defaults using @see cnSettingsAPI::registerFields().
		 *
		 * @access private
		 * @since  5.0
		 *
		 * @param array $fields
		 *
		 * @return array
		 */
		public static function registerSettingsDefaults( $fields ) {

			$fields[] = array(
				'plugin_id' => 'connections_template',
				'section'   => self::SLUG,
				'id'        => 'card',
				'type'      => 'customizer',
				'default'   => array(
					'search'                     => TRUE,
					'pagination'                 => TRUE,
					'pagination_limit'           => 20,
					'pagination_position'        => 'after',
					'category_select'            => TRUE,
					'show_empty_categories'      => TRUE,
					'show_category_count'        => FALSE,
					'enable_map'                 => TRUE,
					'show_title'                 => TRUE,
					'show_org'                   => TRUE,
					'show_dept'                  => TRUE,
					'show_contact_name'          => TRUE,
					'show_family'                => TRUE,
					'show_addresses'             => TRUE,
					'show_phone_numbers'         => TRUE,
					'show_email'                 => TRUE,
					'show_im'                    => TRUE,
					'show_social_media'          => TRUE,
					'show_links'                 => TRUE,
					'show_dates'                 => TRUE,
					'show_bio'                   => TRUE,
					'show_notes'                 => TRUE,
					'show_categories'            => FALSE,
					'show_last_updated'          => FALSE,
					'show_return_to_top'         => TRUE,
					'image_type'                 => 'logo',
					'image_width'                => NULL,
					'image_height'               => NULL,
					'image_crop_mode'            => '1',
					'image_fallback'             => TRUE,
					'image_fallback_string'      => __( 'No Image Available', 'cnt_cmap' ),
					'tray_image_type'            => 'photo',
					'tray_image_width'           => NULL,
					'tray_image_height'          => NULL,
					'tray_image_crop_mode'       => '1',
					'tray_image_fallback'        => FALSE,
					'tray_image_fallback_string' => __( 'No Image Available', 'cnt_cmap' ),
					'name_format'                => '',
					'contact_name_format'        => '',
					'address_format'             => '',
					'address_types'              => '',
					'phone_format'               => '',
					'phone_types'                => '',
					'email_format'               => '',
					'email_types'                => '',
					'date_format'                => '',
					'date_types'                 => '',
					'link_format'                => '',
					'link_types'                 => '',
					'str_select'                 => __( 'Select Category', 'cnt_cmap' ),
					'str_select_all'             => __( 'Show All Categories', 'cnt_cmap' ),
					'str_map_show'               => __( 'Show Map', 'cnt_cmap' ),
					'str_map_hide'               => __( 'Close Map', 'cnt_cmap' ),
					'str_bio_head'               => __( 'Biography', 'cnt_cmap' ),
					'str_bio_show'               => __( 'Show Bio', 'cnt_cmap' ),
					'str_bio_hide'               => __( 'Close Bio', 'cnt_cmap' ),
					'str_note_head'              => __( 'Notes', 'cnt_cmap' ),
					'str_note_show'              => __( 'Show Notes', 'cnt_cmap' ),
					'str_note_hide'              => __( 'Close Notes', 'cnt_cmap' ),
					'str_contact_label'          => __( 'Contact', 'cnt_cmap' ),
					'str_category_label'         => __( 'Categories:', 'cnt_cmap' ),
					'border_width'               => 1,
					'border_color'               => '#E3E3E3',
					'border_radius'              => 4,
					'background_color'           => '#E3E3E3',
					'background_gradient'        => TRUE,
					'background_shadow'          => TRUE,
					'text_color'                 => '#000',
					'tray_background_color'      => '#F1F1F1',
					'tray_text_color'            => '#000',
				)
			);

			$fields[] = array(
				'plugin_id' => 'connections_template',
				'section'   => self::SLUG,
				'id'        => 'single',
				'type'      => 'customizer',
				'default'   => array(
					'enable_map'                 => TRUE,
					'show_title'                 => TRUE,
					'show_org'                   => TRUE,
					'show_dept'                  => TRUE,
					'show_contact_name'          => TRUE,
					'show_family'                => TRUE,
					'show_addresses'             => TRUE,
					'show_phone_numbers'         => TRUE,
					'show_email'                 => TRUE,
					'show_im'                    => TRUE,
					'show_social_media'          => TRUE,
					'show_links'                 => TRUE,
					'show_dates'                 => TRUE,
					'show_bio'                   => TRUE,
					'show_notes'                 => TRUE,
					'show_categories'            => FALSE,
					'show_last_updated'          => FALSE,
					'image_type'                 => 'logo',
					'image_width'                => NULL,
					'image_height'               => NULL,
					'image_crop_mode'            => '1',
					'image_fallback'             => TRUE,
					'image_fallback_string'      => __( 'No Image Available', 'cnt_cmap' ),
					'tray_image_type'            => 'photo',
					'tray_image_width'           => NULL,
					'tray_image_height'          => NULL,
					'tray_image_crop_mode'       => '1',
					'tray_image_fallback'        => FALSE,
					'tray_image_fallback_string' => __( 'No Image Available', 'cnt_cmap' ),
					'name_format'                => '',
					'contact_name_format'        => '',
					'address_format'             => '',
					'address_types'              => '',
					'phone_format'               => '',
					'phone_types'                => '',
					'email_format'               => '',
					'email_types'                => '',
					'date_format'                => '',
					'date_types'                 => '',
					'link_format'                => '',
					'link_types'                 => '',
					'str_bio_head'               => __( 'Biography', 'cnt_cmap' ),
					'str_note_head'              => __( 'Notes', 'cnt_cmap' ),
					'str_contact_label'          => __( 'Contact', 'cnt_cmap' ),
					'str_category_label'         => __( 'Categories:', 'cnt_cmap' ),
				)
			);

			return $fields;
		}

		/**
		 * Render the custom CSS inline.
		 *
		 * @access private
		 * @since  5.0
		 *
		 * @param string $handle
		 */
		public static function inlineStyle( $handle ) {

			if ( ! get_query_var( 'cn-entry-slug' ) ) {

				/**
				 * @var cnOutput $entry
				 * @var array    $option
				 */
				$options = cnSettingsAPI::get( 'connections_template', self::$template->getSlug(), 'card' );
				$style   = <<<HEREDOC
/* cMap Template Customizer Custom Styles */
#cn-cmap .cn-list-row,
#cn-cmap .cn-list-row a,
#cn-cmap .cn-list-row a:visited,
#cn-cmap .cn-list-row-alternate,
#cn-cmap .cn-list-row-alternate a,
#cn-cmap .cn-list-row-alternate a:visited {
	color: {$options['text_color']};
}
#cn-cmap .cn-content-tray .cn-bio-tray,
#cn-cmap .cn-content-tray .cn-note-tray,
#cn-cmap .cn-content-tray .cn-gmap {
	background-color: {$options['tray_background_color']};
}
#cn-cmap .cn-content-tray,
#cn-cmap .cn-content-tray a,
#cn-cmap .cn-content-tray a:visited {
	color: {$options['tray_text_color']};
}
HEREDOC;

				wp_add_inline_style( $handle, $style );
			}
		}

		/**
		 * Initiate the permitted template shortcode options and load the default values.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param  array  $permittedAtts The shortcode $atts array.
		 *
		 * @return array
		 */
		public static function initShortcodeAtts( $permittedAtts = array() ) {

			if ( get_query_var('cn-entry-slug') ) {

				/**
				 * @var cnOutput $entry
				 * @var array    $options
				 */
				$options = cnSettingsAPI::get( 'connections_template', self::$template->getSlug(), 'single' );

			} else {

				/**
				 * @var cnOutput $entry
				 * @var array    $options
				 */
				$options = cnSettingsAPI::get( 'connections_template', self::$template->getSlug(), 'card' );

				$permittedAtts['enable_search']                   = $options['search'];

				$permittedAtts['enable_pagination']               = $options['pagination'];
				$permittedAtts['page_limit']                      = $options['pagination_limit'];
				$permittedAtts['pagination_position']             = $options['pagination_position'];

				$permittedAtts['enable_category_select']          = $options['category_select'];
				$permittedAtts['show_empty_categories']           = $options['show_empty_categories'];
				$permittedAtts['show_category_count']             = $options['show_category_count'];
				$permittedAtts['category_select_position']        = 'before';
				$permittedAtts['enable_category_by_root_parent']  = FALSE;
				$permittedAtts['enable_category_multi_select']    = FALSE;
				$permittedAtts['enable_category_group_by_parent'] = FALSE;

				$permittedAtts['show_return_to_top']              = $options['show_return_to_top'];

				$permittedAtts['str_select']                      = __( $options['str_select'], 'cnt_cmap' );
				$permittedAtts['str_select_all']                  = __( $options['str_select_all'], 'cnt_cmap' );
				$permittedAtts['str_map_show']                    = __( $options['str_map_show'], 'cnt_cmap' );
				$permittedAtts['str_map_hide']                    = __( $options['str_map_hide'], 'cnt_cmap' );
				$permittedAtts['str_bio_show']                    = __( $options['str_bio_show'], 'cnt_cmap' );
				$permittedAtts['str_bio_hide']                    = __( $options['str_bio_hide'], 'cnt_cmap' );
				$permittedAtts['str_note_show']                   = __( $options['str_note_show'], 'cnt_cmap' );
				$permittedAtts['str_note_hide']                   = __( $options['str_note_hide'], 'cnt_cmap' );

				$permittedAtts['border_width']                    = $options['border_width'];
				$permittedAtts['border_color']                    = $options['border_color'];
				$permittedAtts['border_radius']                   = $options['border_radius'];

				$permittedAtts['background_color']                = $options['background_color'];
				$permittedAtts['background_gradient']             = $options['background_gradient'];
				$permittedAtts['background_shadow']               = $options['background_shadow'];

				$permittedAtts['text_color']                      = $options['text_color'];
			}

			// Grab an instance of the Connections object.
			$instance = Connections_Directory();

			$addressLabel = $instance->options->getDefaultAddressValues();
			$phoneLabel   = $instance->options->getDefaultPhoneNumberValues();
			$emailLabel   = $instance->options->getDefaultEmailValues();

			$permittedAtts['enable_map']                      = $options['enable_map'];
			$permittedAtts['enable_bio']                      = $options['show_bio'];
			$permittedAtts['enable_bio_head']                 = TRUE;
			$permittedAtts['enable_note']                     = $options['show_notes'];
			$permittedAtts['enable_note_head']                = TRUE;

			$permittedAtts['show_title']                      = $options['show_title'];
			$permittedAtts['show_org']                        = $options['show_org'];
			$permittedAtts['show_dept']                       = $options['show_dept'];
			$permittedAtts['show_contact_name']               = $options['show_contact_name'];
			$permittedAtts['show_family']                     = $options['show_family'];
			$permittedAtts['show_addresses']                  = $options['show_addresses'];
			$permittedAtts['show_phone_numbers']              = $options['show_phone_numbers'];
			$permittedAtts['show_email']                      = $options['show_email'];
			$permittedAtts['show_im']                         = $options['show_im'];
			$permittedAtts['show_social_media']               = $options['show_social_media'];
			$permittedAtts['show_dates']                      = $options['show_dates'];
			$permittedAtts['show_links']                      = $options['show_links'];
			$permittedAtts['show_last_updated']               = $options['show_last_updated'];
			$permittedAtts['show_categories']                 = $options['show_categories'];

			$permittedAtts['address_types']                   = $options['address_types'];
			$permittedAtts['phone_types']                     = $options['phone_types'];
			$permittedAtts['email_types']                     = $options['email_types'];
			$permittedAtts['date_types']                      = $options['date_types'];
			$permittedAtts['link_types']                      = $options['link_types'];

			$permittedAtts['image']                           = $options['image_type'];
			$permittedAtts['image_width']                     = $options['image_width'];
			$permittedAtts['image_height']                    = $options['image_height'];
			$permittedAtts['image_crop_mode']                 = $options['image_crop_mode'];
			$permittedAtts['image_fallback']                  = $options['image_fallback'] ? 'block' : 'none';
			$permittedAtts['tray_image']                      = $options['tray_image_type'];
			$permittedAtts['tray_image_width']                = $options['tray_image_width'];
			$permittedAtts['tray_image_height']               = $options['tray_image_height'];
			$permittedAtts['tray_image_crop_mode']            = $options['tray_image_crop_mode'];
			$permittedAtts['tray_image_fallback']             = $options['tray_image_fallback'] ? 'block' : 'none';

			// $permittedAtts['map_type']                        = 'm';
			$permittedAtts['map_zoom']                        = 13;
			$permittedAtts['map_frame_height']                = 400;

			$permittedAtts['str_image']                       = __( $options['image_fallback_string'], 'cnt_cmap' );
			$permittedAtts['str_tray_image']                  = __( $options['tray_image_fallback_string'], 'cnt_cmap' );
			$permittedAtts['str_bio_head']                    = __( $options['str_bio_head'], 'cnt_cmap' );
			$permittedAtts['str_note_head']                   = __( $options['str_note_head'], 'cnt_cmap' );
			$permittedAtts['str_contact']                     = __( $options['str_contact_label'], 'cnt_cmap' );
			$permittedAtts['str_category_label']              = __( $options['str_category_label'], 'cnt_cmap' );
			$permittedAtts['str_home_addr']                   = $addressLabel['home'];
			$permittedAtts['str_work_addr']                   = $addressLabel['work'];
			$permittedAtts['str_school_addr']                 = $addressLabel['school'];
			$permittedAtts['str_other_addr']                  = $addressLabel['other'];
			$permittedAtts['str_home_phone']                  = $phoneLabel['homephone'];
			$permittedAtts['str_home_fax']                    = $phoneLabel['homefax'];
			$permittedAtts['str_cell_phone']                  = $phoneLabel['cellphone'];
			$permittedAtts['str_work_phone']                  = $phoneLabel['workphone'];
			$permittedAtts['str_work_fax']                    = $phoneLabel['workfax'];
			$permittedAtts['str_personal_email']              = $emailLabel['personal'];
			$permittedAtts['str_work_email']                  = $emailLabel['work'];

			$permittedAtts['name_format']                     = $options['name_format'];
			$permittedAtts['contact_name_format']             = $options['contact_name_format'];
			$permittedAtts['addr_format']                     = $options['address_format'];
			$permittedAtts['email_format']                    = $options['email_format'];
			$permittedAtts['phone_format']                    = $options['phone_format'];
			$permittedAtts['link_format']                     = $options['link_format'];
			$permittedAtts['date_format']                     = $options['date_format'];

			// Set this option so we can define template functionality: should we expand details or link to the single entry page.
			$permittedAtts['link']                            = cnSettingsAPI::get( 'connections', 'connections_link', 'name' );

			return $permittedAtts;
		}

		/**
		 * Initiate the template options using the user supplied shortcode option values.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param  array $atts The shortcode $atts array.
		 *
		 * @return array
		 */
		public static function initTemplateOptions( $atts ) {

			// Because the shortcode option values are treated as strings some of the values have to converted to boolean.
			cnFormatting::toBoolean( $atts['enable_search'] );
			cnFormatting::toBoolean( $atts['enable_pagination'] );
			cnFormatting::toBoolean( $atts['enable_category_select'] );
			cnFormatting::toBoolean( $atts['show_empty_categories'] );
			cnFormatting::toBoolean( $atts['show_category_count'] );
			cnFormatting::toBoolean( $atts['enable_category_by_root_parent'] );
			cnFormatting::toBoolean( $atts['enable_category_multi_select'] );
			cnFormatting::toBoolean( $atts['enable_category_group_by_parent'] );
			cnFormatting::toBoolean( $atts['enable_map'] );
			cnFormatting::toBoolean( $atts['enable_bio'] );
			cnFormatting::toBoolean( $atts['enable_bio_head']);
			cnFormatting::toBoolean( $atts['enable_note'] );
			cnFormatting::toBoolean( $atts['enable_note_head'] );

			cnFormatting::toBoolean( $atts['show_title'] );
			cnFormatting::toBoolean( $atts['show_org'] );
			cnFormatting::toBoolean( $atts['show_dept'] );
			cnFormatting::toBoolean( $atts['show_contact_name'] );
			cnFormatting::toBoolean( $atts['show_family'] );
			cnFormatting::toBoolean( $atts['show_addresses'] );
			cnFormatting::toBoolean( $atts['show_phone_numbers'] );
			cnFormatting::toBoolean( $atts['show_email'] );
			cnFormatting::toBoolean( $atts['show_im'] );
			cnFormatting::toBoolean( $atts['show_social_media'] );
			cnFormatting::toBoolean( $atts['show_dates'] );
			cnFormatting::toBoolean( $atts['show_links'] );
			cnFormatting::toBoolean( $atts['show_categories'] );
			cnFormatting::toBoolean( $atts['show_last_updated'] );
			cnFormatting::toBoolean( $atts['show_return_to_top'] );

			cnFormatting::toBoolean( $atts['link'] );

			cnFormatting::toBoolean( $atts['background_gradient'] );
			cnFormatting::toBoolean( $atts['background_shadow'] );

			// Set the entry card width and map iframe width defaults
			if ( empty( $atts['width'] ) ) {
				$atts['map_frame_width'] = NULL;
			} else {
				$width = get_query_var( 'cn-entry-slug' ) ? 16 : 50;
				$atts['map_frame_width'] = $atts['width'] - $width;
			}

			// If displaying a single entry, no need to display category select, search and pagination.
			if ( get_query_var( 'cn-entry-slug' ) ) {
				$atts['enable_search']          = FALSE;
				$atts['enable_pagination']      = FALSE;
				$atts['enable_category_select'] = FALSE;
			}

			add_filter( 'cn_phone_number' , array( __CLASS__, 'phoneLabels') );
			add_filter( 'cn_email_address' , array( __CLASS__, 'emailLabels') );
			add_filter( 'cn_address' , array( __CLASS__, 'addressLabels') );

			// Start the form.
			add_action( 'cn_action_list_before-' . self::$template->getSlug() , array( __CLASS__, 'formOpen'), -1 );

			// Close the form
			add_action( 'cn_action_list_before-' . self::$template->getSlug() , array( __CLASS__, 'formClose'), 99999 );

			// If search is enabled, add the appropriate filters.
			if ( $atts['enable_search'] ) {
				//add_filter( 'cn_list_retrieve_atts-' . self::$template->getSlug() , array( __CLASS__, 'limitList'), 10 );
				add_action( 'cn_action_list_before-' . self::$template->getSlug() , array( __CLASS__, 'searchForm') , 1 );
			}

			// If pagination is enabled add the appropriate filters.
			if ( $atts['enable_pagination'] ) {
				add_filter( 'cn_list_retrieve_atts-' . self::$template->getSlug() , array( __CLASS__, 'limitList'), 10 );
				add_action( 'cn_action_list_' . $atts['pagination_position'] . '-' . self::$template->getSlug() , array( __CLASS__, 'listPages') );
			}

			// If the category select/filter feature is enabled, add the appropriate filters.
			if ( $atts['enable_category_select'] ) {
				add_filter( 'cn_list_retrieve_atts-' . self::$template->getSlug() , array( __CLASS__, 'setCategory') );
				add_action( 'cn_action_list_' . $atts['category_select_position'] . '-' . self::$template->getSlug() , array( __CLASS__, 'categorySelect') , 5 );
			}

			// Store a copy of the shortcode $atts to be used in other class methods.
			self::$atts = $atts;

			return $atts;
		}

		/**
		 * Alter the Address Labels.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param object $data
		 *
		 * @return object
		 */
		public static function addressLabels( $data ) {

			switch ( $data->type ) {
				case 'home':
					$data->name = self::$atts['str_home_addr'];
					break;
				case 'work':
					$data->name = self::$atts['str_work_addr'];
					break;
				case 'school':
					$data->name = self::$atts['str_school_addr'];
					break;
				case 'other':
					$data->name = self::$atts['str_other_addr'];
					break;
			}

			return $data;
		}

		/**
		 * Alter the Phone Labels.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param object $data
		 *
		 * @return object
		 */
		public static function phoneLabels( $data ) {

			switch ( $data->type ) {
				case 'homephone':
					$data->name = self::$atts['str_home_phone'];
					break;
				case 'homefax':
					$data->name = self::$atts['str_home_fax'];
					break;
				case 'cellphone':
					$data->name = self::$atts['str_cell_phone'];
					break;
				case 'workphone':
					$data->name = self::$atts['str_work_phone'];
					break;
				case 'workfax':
					$data->name = self::$atts['str_work_fax'];
					break;
			}

			return $data;
		}

		/**
		 * Alter the Email Labels.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param object $data
		 *
		 * @return object
		 */
		public static function emailLabels( $data ) {

			switch ( $data->type ) {
				case 'personal':
					$data->name = self::$atts['str_personal_email'];
					break;
				case 'work':
					$data->name = self::$atts['str_work_email'];
					break;

				default:
					$data->name = 'Email';
				break;
			}

			return $data;
		}

		/**
		 * Limit the returned results.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param array $atts The shortcode $atts array.
		 *
		 * @return array
		 */
		public static function limitList( $atts ) {

			// $atts['limit'] = $this->pageLimit; // Page Limit
			$atts['limit'] = empty( $atts['limit'] ) ? $atts['page_limit'] : $atts['limit'];

			return $atts;
		}

		/**
		 * Echo the form beginning.
		 *
		 * @access private
		 * @since  3.0
		 *
		 * @param array $atts
		 */
		public static function formOpen( $atts ) {

		    cnTemplatePart::formOpen( $atts );
		}

		/**
		 * Echo the form ending.
		 *
		 * @access private
		 * @since  3.0
		 */
		public static function formClose() {

		    cnTemplatePart::formClose();
		}

		/**
		 * Output the search input fields.
		 *
		 * @access private
		 * @since  3.0
		 */
		public static function searchForm() {

			cnTemplatePart::search();
		}

		/**
		 * Output the pagination control.
		 *
		 * @access private
		 * @since  3.0
		 */
		public static function listPages() {

			cnTemplatePart::pagination( array( 'limit' => self::$atts['page_limit'] ) );

		}

		/**
		 * Outputs the category select list.
		 *
		 * @access private
		 * @since  3.0
		 */
		public static function categorySelect() {

			$atts = array(
				'default'    => __( self::$atts['str_select'], 'cnt_cmap' ),
				'select_all' => __( self::$atts['str_select_all'], 'cnt_cmap' ),
				'type'       => self::$atts['enable_category_multi_select'] ? 'multiselect' : 'select',
				'group'      => self::$atts['enable_category_group_by_parent'],
				'show_count' => self::$atts['show_category_count'],
				'show_empty' => self::$atts['show_empty_categories'],
				'parent_id'  => self::$atts['enable_category_by_root_parent'] ? self::$atts['category'] : array(),
				'exclude'    => self::$atts['exclude_category'],
				);

			cnTemplatePart::category( $atts );
		}

		/**
		 * Alters the shortcode attribute values before the query is processed.
		 *
		 * @access private
		 * @since 3.0
		 * @param  (array)  $atts The shortcode $atts array.
		 * @return (array)
		 */
		public static function setCategory( $atts ) {

			if ( $atts['enable_category_multi_select'] ) {

				if ( get_query_var('cn-cat') ) $atts['category_in'] = get_query_var('cn-cat');
				remove_query_arg( 'cn-cat' );

			}

			return $atts;
		}

		/**
		 * Include the Template Customizer support file if the template is being customized.
		 *
		 * @access private
		 * @since  5.0
		 */
		public static function includeCustomizer() {

			if ( isset( $_REQUEST['cn-template'] ) && self::SLUG == $_REQUEST['cn-template'] ) {

				require_once plugin_dir_path( __FILE__ ) . 'class.customizer.php';
			}
		}

	}

	// Register the template.
	add_action( 'cn_register_template', array( 'CN_cMap', 'register' ) );

	// Include the Customizer configuration file for the template.
	add_action( 'cn_template_customizer_include', array( 'CN_cMap', 'includeCustomizer' ) );
}
