<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class cncMap_Customizer {

	public static function init() {

		add_filter( 'cn_template_customizer_sections', array( __CLASS__, 'addSectionExemptions' ) );

		add_action( 'cn_template_customizer_sections_before', array( __CLASS__, 'addSections' ) );
		add_action( 'cn_template_customizer_register-card', array( __CLASS__, 'addControls' ), 10, 2 );

		add_action( 'cn_template_customizer_register', array( __CLASS__, 'addTrayImageControls' ), 10, 3 );
		add_action( 'cn_template_customizer_register', array( __CLASS__, 'addMapControls' ), 10, 3 );
	}

	public static function addSectionExemptions( $exemptions ) {

		$exemptions[] = 'cn_template_customizer_section_tray_image';
		$exemptions[] = 'cn_template_customizer_section_map';

		return $exemptions;
	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 */
	public static function addSections( $wp_customize ) {

		$wp_customize->add_section(
			'cn_template_customizer_section_tray_image',
			array(
				'title'       => __( 'Bio Tray Image', 'cnt_cmap' ),
				//'description' => __( '', 'cnt_cmap' ),
				'panel'       => 'cn_template',
				'priority'    => 55,
				'capability'  => 'edit_theme_options',
			)
		);

		$wp_customize->add_section(
			'cn_template_customizer_section_map',
			array(
				'title'       => __( 'Map', 'cnt_cmap' ),
				//'description' => __( '', 'cnt_cmap' ),
				'panel'       => 'cn_template',
				'priority'    => 55,
				'capability'  => 'edit_theme_options',
			)
		);
	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 * @param object               $template
	 */
	public static function addControls( $wp_customize, $template ) {

		self::addPaginationControls( $wp_customize, $template );
		self::addStyleControls( $wp_customize, $template );
	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 * @param object               $template
	 */
	private static function addPaginationControls( $wp_customize, $template ) {

		$base = 'connections_template';
		$slug = $template->slug;
		//$id   = 'cn_card_border_width';
		$wp_customize->add_setting(
			"{$base}_{$slug}[card][pagination_position]",
			array(
				'type'                 => 'option',
				'default'              => 'after',
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_card_pagination_position",
				array(
					'label'       => __( 'Pagination Position', 'cnt_cmap' ),
					'type'        => 'select',
					'section'     => 'cn_template_customizer_section_pagination',
					'settings'    => "{$base}_{$slug}[card][pagination_position]",
					'description' => __( 'Choose where to display the pagination controls.', 'cnt_cmap' ),
					'choices'     => array(
						'before' => __( 'Before', 'cnt_cmap' ),
						'after' => __( 'After', 'cnt_cmap' ),
					),
				)
			)
		);

	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 * @param object               $template
	 */
	private static function addStyleControls( $wp_customize, $template ) {

		$base = 'connections_template';
		$slug = $template->slug;
		//$id   = 'cn_card_border_width';

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][border_width]",
			array(
				'type'       => 'option',
				'default'    => 1,
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'sanitize_callback'    => 'absint',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_card_border_width",
				array(
					'label'       => __( 'Border Width', 'cnt_cmap' ),
					'type'        => 'number',
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][border_width]",
					'description' => __( 'Enter border width in pixels.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][border_color]",
			array(
				'type'       => 'option',
				'default'    => '#D3D3D3',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				array( 'cnSanitize', 'hexColor' )
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				"cn_{$slug}_card_border_color",
				array(
					'label'       => __( 'Border Color', 'cnt_cmap' ),
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][border_color]",
					//'description' => __( 'Enter border width in pixels.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][border_radius]",
			array(
				'type'       => 'option',
				'default'    => 1,
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'sanitize_callback'    => 'absint',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_card_border_radius",
				array(
					'label'       => __( 'Border Radius', 'cnt_cmap' ),
					'type'        => 'number',
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][border_radius]",
					'description' => __( 'Enter border width in pixels.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][background_color]",
			array(
				'type'       => 'option',
				'default'    => '#E3E3E3',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				array( 'cnSanitize', 'hexColor' )
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				"cn_{$slug}_card_background_color",
				array(
					'label'       => __( 'Background Color', 'cnt_cmap' ),
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][background_color]",
					'description' => __( 'Change the background color.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][background_gradient]",
			array(
				'type'                 => 'option',
				'default'              => TRUE,
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_card_background_gradient",
				array(
					'label'       => __( 'Background Gradient', 'cnt_cmap' ),
					'type'        => 'checkbox',
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][background_gradient]",
					'description' => __( 'Whether or not to gradate the background color.', 'cnt_cmap' )
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][background_shadow]",
			array(
				'type'                 => 'option',
				'default'              => TRUE,
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_card_background_shadow",
				array(
					'label'       => __( 'Background Shadow', 'cnt_cmap' ),
					'type'        => 'checkbox',
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][background_shadow]",
					'description' => __( 'Whether or not to display the background shadow.', 'cnt_cmap' )
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][text_color]",
			array(
				'type'       => 'option',
				'default'    => '#000',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				//'sanitize_callback'    => 'absint',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				"cn_{$slug}_card_text_color",
				array(
					'label'       => __( 'Text Color', 'cnt_cmap' ),
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][text_color]",
					'description' => __( 'Change the text color.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][tray_background_color]",
			array(
				'type'       => 'option',
				'default'    => '#F1F1F1',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'sanitize_callback'    => array( 'cnSanitize', 'hexColor' ),
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				"cn_{$slug}_card_tray_background_color",
				array(
					'label'       => __( 'Tray Background Color', 'cnt_cmap' ),
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][tray_background_color]",
					'description' => __( 'Change the content tray background color.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[card][tray_text_color]",
			array(
				'type'       => 'option',
				'default'    => '#000',
				'transport'  => 'refresh',
				'capability' => 'edit_theme_options',
				'sanitize_callback'    => array( 'cnSanitize', 'hexColor' ),
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				"cn_{$slug}_card_tray_text_color",
				array(
					'label'       => __( 'Tray Text Color', 'cnt_cmap' ),
					'section'     => 'cn_template_customizer_section_style',
					'settings'    => "{$base}_{$slug}[card][tray_text_color]",
					'description' => __( 'Change the content tray text color.', 'cnt_cmap' ),
				)
			)
		);
	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 * @param object               $template
	 * @param string               $view
	 */
	public static function addTrayImageControls( $wp_customize, $template, $view ) {

		$base = 'connections_template';
		$slug = $template->slug;

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_type]",
			array(
				'type'                 => 'option',
				'default'              => 'photo',
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_type",
				array(
					'label'       => __( 'Type', 'cnt_cmap' ),
					'type'        => 'select',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_type]",
					'description' => __( 'Select image type to display.', 'cnt_cmap' ),
					'choices'     => array(
						'none'  => __( 'None', 'cnt_cmap' ),
						'photo' => __( 'Photo', 'cnt_cmap' ),
						'logo'  => __( 'Logo', 'cnt_cmap' ),
					),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_width]",
			array(
				'type'                 => 'option',
				'default'              => '',
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				'sanitize_callback'    => 'absint',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_width",
				array(
					'label'       => __( 'Width', 'cnt_cmap' ),
					'type'        => 'number',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_width]",
					'description' => __( 'Set the image width in pixels.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_height]",
			array(
				'type'                 => 'option',
				'default'              => '',
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				'sanitize_callback'    => 'absint',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_height",
				array(
					'label'       => __( 'Height', 'cnt_cmap' ),
					'type'        => 'number',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_height]",
					'description' => __( 'Set the image width in pixels.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_crop_mode]",
			array(
				'type'                 => 'option',
				'default'              => '1',
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_crop_mode",
				array(
					'label'       => __( 'Crop Mode', 'cnt_cmap' ),
					'type'        => 'radio',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_crop_mode]",
					'description' => __( 'Select the image crop mode.', 'cnt_cmap' ),
					'choices'     => array(
						'1' => __(
							'Crop and resize proportionally to best fit the specified dimensions, maintaining the aspect ratio.',
							'cnt_cmap'
						),
						'2' => __(
							'Resize proportionally to fit entire image into the specified dimensions and add margins if required.',
							'cnt_cmap'
						),
						'3'  => __(
							'Resize proportionally adjusting the size of scaled image so there are no margins added.',
							'cnt_cmap'
						),
						'none' => __( 'Resize to fit the specified dimensions (no cropping).', 'cnt_cmap' )
					),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_fallback]",
			array(
				'type'                 => 'option',
				'default'              => TRUE,
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_fallback",
				array(
					'label'       => __( 'Image Placeholder', 'cnt_cmap' ),
					'type'        => 'checkbox',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_fallback]",
					'description' => __( 'Whether or not an image placeholder is displayed if the selected image type does not exist.', 'cnt_cmap' ),
				)
			)
		);

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][tray_image_fallback_string]",
			array(
				'type'                 => 'option',
				'default'              => __( 'No Image Available', 'cnt_cmap' ),
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_tray_image_fallback_string",
				array(
					'label'       => __( 'Image Placeholder Text', 'cnt_cmap' ),
					'type'        => 'text',
					'section'     => 'cn_template_customizer_section_tray_image',
					'settings'    => "{$base}_{$slug}[{$view}][tray_image_fallback_string]",
					'description' => __( 'The text to display if no image is available.', 'cnt_cmap' ),
				)
			)
		);
	}

	/**
	 * @param WP_Customize_Manager $wp_customize
	 * @param object               $template
	 * @param string               $view
	 */
	public static function addMapControls( $wp_customize, $template, $view ) {

		$base = 'connections_template';
		$slug = $template->slug;
		//$id   = 'cn_card_border_width';

		$wp_customize->add_setting(
			"{$base}_{$slug}[{$view}][enable_map]",
			array(
				'type'                 => 'option',
				'default'              => TRUE,
				'transport'            => 'refresh',
				'capability'           => 'edit_theme_options',
				//'sanitize_callback'    => 'sanitize_text_field',
				//'sanitize_js_callback' => '',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				"cn_{$slug}_{$view}_enable_map",
				array(
					'label'       => __( 'Enable', 'cnt_cmap' ),
					'type'        => 'checkbox',
					'section'     => 'cn_template_customizer_section_map',
					'settings'    => "{$base}_{$slug}[{$view}][enable_map]",
					'description' => __( 'Whether or not to display the map.', 'cnt_cmap' ),
				)
			)
		);
	}
}

cncMap_Customizer::init();
