<?php
/** @var array $atts */
/** @var array $style */
$style  = array(
	'background-color' => $atts['background_color'],
	'border'           => $atts['border_width'] . 'px solid ' . $atts['border_color'],
	'border-radius'    => $atts['border_radius'] . 'px',
	//'color'            => '#000',
	'margin'           => '8px 0',
	'padding'          => '10px',
	'position'         => 'relative',
);

/** @var array $class */
$class = array( 'cn-entry' );

if ( $atts['background_gradient'] ) {

	$class[] = 'cn-background-gradient';
}

if ( $atts['background_shadow'] ) {

	$class[] = 'cn-background-shadow';
}

/** @var cnOutput $entry */
?>
<div id="entry-id-<?php echo $entry->getRuid(); ?>" <?php echo cnHTML::attribute( 'class', $class ); ?> <?php echo cnHTML::attribute( 'style', $style ); ?>>

	<div class="cn-card-content-holder">

		<div>
			<h3> <?php $entry->getNameBlock( array( 'format' => $atts['name_format'], 'link' => FALSE ) ); ?></h3>
			<?php
			if ( $atts['show_title'] ) $entry->getTitleBlock();

			if ( $atts['show_org'] || $atts['show_dept'] ) {

				$entry->getOrgUnitBlock(
					array(
						'show_org'  => $atts['show_org'],
						'show_dept' => $atts['show_dept'],
					)
				);
			}

			if ( $atts['show_contact_name'] ) {

				$entry->getContactNameBlock(
					array(
						'format' => $atts['contact_name_format'],
						'label'  => $atts['str_contact']
					)
				);
			}
			?>
		</div>

		<?php

		if ( $atts['show_addresses'] ) $entry->getAddressBlock( array( 'format' => $atts['addr_format'] , 'type' => $atts['address_types'] ) );

		if ( $atts['show_phone_numbers'] ) $entry->getPhoneNumberBlock( array( 'format' => $atts['phone_format'] , 'type' => $atts['phone_types'] ) );

		if ( $atts['show_email'] ) $entry->getEmailAddressBlock( array( 'format' => $atts['email_format'] , 'type' => $atts['email_types'] ) );

		if ( $atts['show_im'] ) $entry->getImBlock();

		if ( $atts['show_social_media'] ) $entry->getSocialMediaBlock();

		if ( $atts['show_dates'] ) $entry->getDateBlock( array( 'format' => $atts['date_format'], 'type' => $atts['date_types'] ) );

		if ( $atts['show_links'] ) $entry->getLinkBlock( array( 'format' => $atts['link_format'], 'type' => $atts['link_types'] ) );

		if ( $atts['show_family'] )$entry->getFamilyMemberBlock();

		?>
	</div><!-- /.cn-right -->

	<div class="cn-clear"></div>

	<?php $entry->getContentBlock( $atts['content'], $atts, $template ); ?>

	<div class="cn-clear" style="display:table;margin: 10px 0;width:100%;">
		<div style="display:table-cell;vertical-align:middle;">
			<?php
			if ( $atts['show_categories'] ) {

				$entry->getCategoryBlock(
					array(
						'separator' => ', ',
						'label'     => __( $atts['str_category_label'], 'cnt_cmap' ),
					)
				);
			}
			?>
		</div>
		<div style="display:table-cell;text-align:right;vertical-align:middle;">
			<?php
			if ( $atts['show_last_updated'] ) {

				cnTemplatePart::updated(
					array(
						'timestamp' => $entry->getUnixTimeStamp(),
						'style'     => array(
							'font-variant' => 'small-caps',
						)
					)
				);
			}
			?>
		</div>
	</div>

	<div class="cn-tray-links">

		<div class="cn-left">
			<?php

			if ( $atts['enable_bio'] && 0 < strlen( $entry->getBio() ) ) {

				printf(
					'<a class="cn-bio-anchor toggle-div" id="bio-anchor-%1$s" href="#" data-uuid="%1$s" data-div-id="bio-block-%1$s" data-str-show="%2$s" data-str-hide="%3$s">%2$s</a>',
					$entry->getRuid(),
					$atts['str_bio_show'],
					$atts['str_bio_hide']
				);
			}

			if ( ( $atts['enable_note'] && 0 < strlen( $entry->getNotes() ) ) &&
			     ( $atts['enable_bio'] && 0 < strlen( $entry->getBio() ) ) ) {

				echo '<span class="toggle-bio-note-divider"> | </span>';
			}

			if ( $atts['enable_note'] && 0 < strlen( $entry->getNotes() ) ) {

				printf(
					'<a class="cn-note-anchor toggle-div" id="note-anchor-%1$s" href="#" data-uuid="%1$s" data-div-id="note-block-%1$s" data-str-show="%2$s" data-str-hide="%3$s">%2$s</a>',
					$entry->getRuid(),
					$atts['str_note_show'],
					$atts['str_note_hide']
				);
			}

			?>
		</div> <!-- /.cn-left -->

		<div class="cn-right">
			<?php

			if ( $atts['enable_map'] ) {

				$gMap = $entry->getMapBlock(
					array(
						'height' => $atts['map_frame_height'],
						'width'  => ( $atts['map_frame_width'] ) ? $atts['map_frame_width'] : NULL,
						'return' => TRUE,
						'zoom'   => $atts['map_zoom']
					)
				);

				if ( ! empty( $gMap ) ) {

					$mapDiv = '<div class="cn-gmap" id="map-container-' . $entry->getRuid() . '" style="display: none;">' . $gMap . '</div>';

					printf(
						'<a class="cn-map-anchor toggle-map" id="map-anchor-%1$s" href="#" data-uuid="%1$s" data-str-show="%2$s" data-str-hide="%3$s">%2$s</a>',
						$entry->getRuid(),
						$atts['str_map_show'],
						$atts['str_map_hide']
					);
				}
			}

			if ( ! empty( $gMap ) && $atts['show_return_to_top'] ) {

				echo '<span class="toggle-map-divider"> | </span>';
			}

			if ( $atts['show_return_to_top'] ) : ?>

				<span class="cn-return-to-top"><?php cnTemplatePart::returnToTop() ?></span>

			<?php endif; ?>

		</div> <!-- /.cn-right -->
	</div> <!-- /.cn-tray-links -->

	<div class="cn-clear"></div>

	<div class="cn-content-tray">
		<?php if ( $atts['enable_bio'] && 0 < strlen( $entry->getBio() ) ) : ?>

			<div class="cn-bio-tray" id="bio-block-<?php echo $entry->getRuid(); ?>" style="display: none;">

				<?php

				if ( $atts['enable_bio_head'] ) echo '<h4>', $atts['str_bio_head'], '</h4>';

				if ( 'none' !== $atts['tray_image'] ) {

					$entry->getImage(
						array(
							'image'    => $atts['tray_image'],
							'width'    => $atts['tray_image_width'],
							'height'   => $atts['tray_image_height'],
							'zc'       => $atts['tray_image_crop_mode'],
							'fallback' => array(
								'type'   => $atts['tray_image_fallback'],
								'string' => $atts['str_tray_image'],
							),
						)
					);

				}

				$entry->getBioBlock();
				?>

				<div class="cn-clear"></div>

			</div>
		<?php endif; ?>

		<?php if ( $atts['enable_note'] && 0 < strlen( $entry->getNotes() ) ) : ?>

			<div class="cn-note-tray" id="note-block-<?php echo $entry->getRuid(); ?>" style="display: none;">

				<?php if ( $atts['enable_note_head'] ) echo '<h4>' , $atts['str_note_head'] , '</h4>'; ?>

				<?php $entry->getNotesBlock(); ?>

				<div class="cn-clear"></div>

			</div>

		<?php endif; ?>

		<?php if ( isset( $mapDiv ) ) echo $mapDiv; ?>
	</div> <!-- /.cn-content-tray -->
</div>